/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk.security;

import com.alibaba.csb.sdk.CsbSDKConstants;
import com.alibaba.csb.sdk.security.ParamNode;
import com.alibaba.csb.sdk.security.SpasSigner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SignUtil {
    private static final Random random = new Random(System.currentTimeMillis());
    private static boolean DEBUG = Boolean.getBoolean("csb.sdk.DEBUG") || Boolean.getBoolean("http.caller.DEBUG");

    private static List<ParamNode> convertSingleValueParms(Map<String, String> map) {
        ArrayList<ParamNode> pnList = new ArrayList<ParamNode>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            ParamNode node = new ParamNode(key, entry.getValue());
            pnList.add(node);
        }
        return pnList;
    }

    private static List<ParamNode> convertMultiValueParams(Map<String, List<String>> map) {
        ArrayList<ParamNode> pnList = new ArrayList<ParamNode>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> vlist = entry.getValue();
            if (vlist == null) {
                ParamNode node = new ParamNode(key, null);
                pnList.add(node);
                continue;
            }
            for (String v : vlist) {
                ParamNode node = new ParamNode(key, v);
                pnList.add(node);
            }
        }
        return pnList;
    }

    public static String sign(Map<String, String> paramsMap, String secretKey) {
        List<ParamNode> paramNodeList = SignUtil.convertSingleValueParms(paramsMap);
        return SignUtil.sign(paramNodeList, secretKey);
    }

    public static String signMultiValueParams(Map<String, List<String>> newParamsMap, String secretKey) {
        List<ParamNode> paramNodeList = SignUtil.convertMultiValueParams(newParamsMap);
        return SignUtil.sign(paramNodeList, secretKey);
    }

    private static String sign(List<ParamNode> paramNodeList, String secretKey) {
        if (paramNodeList == null) {
            paramNodeList = new ArrayList<ParamNode>();
        }
        return SpasSigner.sign(paramNodeList, secretKey);
    }

    public static Map<String, String> newParamsMap(Map<String, List<String>> paramsMap, String apiName, String version, String accessKey, String securityKey, boolean timestampFlag, boolean nonceFlag, Map<String, String> extSignHeaders) {
        String timestampStr;
        HashMap<String, List<String>> newParamsMap = new HashMap<String, List<String>>();
        HashMap<String, String> headerParamsMap = new HashMap<String, String>();
        if (paramsMap != null) {
            newParamsMap.putAll(paramsMap);
        }
        if (apiName != null) {
            newParamsMap.put("_api_name", Arrays.asList(apiName));
            headerParamsMap.put("_api_name", apiName);
        }
        if (version != null) {
            newParamsMap.put("_api_version", Arrays.asList(version));
            headerParamsMap.put("_api_version", version);
        }
        if ((timestampStr = System.getProperty("timestamp")) == null) {
            Long ts = System.currentTimeMillis();
            timestampStr = ts.toString();
        }
        if (nonceFlag && CsbSDKConstants.isNonceEnabled) {
            Object nonceStr = System.getProperty("nonce");
            if (nonceStr == null) {
                Long l = random.nextLong();
                nonceStr = l.toString();
            }
            newParamsMap.put("_api_nonce", Arrays.asList(nonceStr));
            headerParamsMap.put("_api_nonce", (String)nonceStr);
        }
        if (timestampFlag) {
            newParamsMap.put("_api_timestamp", Arrays.asList(timestampStr));
            headerParamsMap.put("_api_timestamp", timestampStr);
        }
        if (extSignHeaders != null) {
            for (Map.Entry entry : extSignHeaders.entrySet()) {
                newParamsMap.put((String)entry.getKey(), Arrays.asList((String)entry.getValue()));
                headerParamsMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (accessKey != null) {
            headerParamsMap.put("_api_access_key", accessKey);
            newParamsMap.put("_api_access_key", Arrays.asList(accessKey));
            newParamsMap.remove("_api_signature");
            newParamsMap.remove("_api_secret_key");
            long currT = System.currentTimeMillis();
            String signKey = SignUtil.signMultiValueParams(newParamsMap, securityKey);
            if (DEBUG) {
                System.out.println("sign parameters:");
                boolean first = true;
                for (String key : newParamsMap.keySet()) {
                    if (!first) {
                        System.out.print(",");
                    }
                    System.out.print(key);
                    first = false;
                }
                System.out.println("  == signature:" + signKey + " costs time =" + (System.currentTimeMillis() - currT) + "ms");
            }
            headerParamsMap.put("_api_signature", signKey);
        }
        return headerParamsMap;
    }
}

