/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.HttpCallerException;
import com.alibaba.csb.sdk.HttpParameters;
import com.alibaba.csb.sdk.internel.HttpClientFactory;
import com.alibaba.csb.sdk.internel.HttpClientHelper;
import com.alibaba.csb.sdk.security.SignUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class HttpCaller {
    private static boolean warmupFlag;
    private static CloseableHttpClient HTTP_CLIENT;
    private static PoolingHttpClientConnectionManager connMgr;
    private static final String RESTFUL_PATH_SIGNATURE_KEY = "csb_restful_path_signature_key";
    private static final String DEFAULT_RESTFUL_PROTOCOL_VERSION = "1.0";
    private static final String RESTFUL_PROTOCOL_VERION_KEY = "restful_protocol_version";
    public static final Boolean DEBUG;
    public static final Boolean SKIP_CONN_POOL;
    private static final int VALIDATE_PERIOD;
    private static final int CLEAN_PERIOD;
    private static final int MAX_CONNECTION_TIMEOUT = -1;
    private static final int MAX_SOCKET_TIMEOUT = -1;
    private static final int MAX_CR_TIMEOUT = -1;
    private static final List<String> SUPPORTED_CONNECTION_PARAMS;
    public static final String trustCA;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static String defaultAK;
    private static String defaultSK;
    private static ThreadLocal<Boolean> toCurlCmd;
    private static ThreadLocal<HttpHost> proxyConfigThreadLocal;
    private static final RequestConfig.Builder requestConfigBuilder;
    private static final ThreadLocal<RequestConfig.Builder> requestConfigBuilderLocal;
    private static final long MAX_FILE_SIZE = 0xA00000L;

    private HttpCaller() {
    }

    public static synchronized void warmup() {
        if (warmupFlag) {
            return;
        }
        SignUtil.sign(new HashMap<String, String>(), "sk");
        warmupFlag = true;
    }

    private static RequestConfig.Builder createConnBuilder() {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        String CONN_TIMEOUT = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(1));
        String SO_TIMEOUT = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(2));
        String CR_TIMEOUT = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(3));
        int iconnTimeout = -1;
        if (CONN_TIMEOUT != null) {
            try {
                iconnTimeout = Integer.parseInt(CONN_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        configBuilder.setConnectTimeout(iconnTimeout);
        int isoTimeout = -1;
        if (SO_TIMEOUT != null) {
            try {
                isoTimeout = Integer.parseInt(SO_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        configBuilder.setSocketTimeout(isoTimeout);
        int icrTimeout = -1;
        if (CR_TIMEOUT != null) {
            try {
                icrTimeout = Integer.parseInt(CR_TIMEOUT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        configBuilder.setConnectionRequestTimeout(icrTimeout);
        configBuilder.setCookieSpec("ignoreCookies");
        return configBuilder;
    }

    public static void setProxyHost(String hostname, int port, String scheme) {
        proxyConfigThreadLocal.set(new HttpHost(hostname, port, scheme));
    }

    public static void setConnectionParams(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            requestConfigBuilderLocal.set(requestConfigBuilder);
        } else {
            RequestConfig.Builder connBuilder = HttpCaller.createConnBuilder();
            for (Map.Entry<String, String> es : params.entrySet()) {
                if (!SUPPORTED_CONNECTION_PARAMS.contains(es.getKey())) {
                    throw new IllegalArgumentException("\u9519\u8bef\u7684connection\u53c2\u6570:" + es.getKey());
                }
                if (connMgr != null && es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(0))) {
                    connMgr.setMaxTotal(Integer.parseInt(es.getValue()));
                } else if (es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(1))) {
                    connBuilder.setConnectTimeout(Integer.parseInt(es.getValue()));
                } else if (es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(2))) {
                    connBuilder.setSocketTimeout(Integer.parseInt(es.getValue()));
                } else if (es.getKey().equals(SUPPORTED_CONNECTION_PARAMS.get(3))) {
                    connBuilder.setConnectionRequestTimeout(Integer.parseInt(es.getValue()));
                }
                HttpClientHelper.printDebugInfo(String.format("set %s as %s", es.getKey(), es.getValue()));
            }
            requestConfigBuilderLocal.set(connBuilder);
        }
    }

    private static RequestConfig getRequestConfig() {
        RequestConfig.Builder rcBuilder = null;
        rcBuilder = requestConfigBuilderLocal.get() == null ? requestConfigBuilder : requestConfigBuilderLocal.get();
        rcBuilder.setProxy(proxyConfigThreadLocal.get());
        return rcBuilder.build();
    }

    public static void setCurlResponse(boolean flag) {
        toCurlCmd.set(true);
    }

    private static boolean isCurlResponse() {
        return toCurlCmd.get() != null && toCurlCmd.get() == true;
    }

    public static void setCredential(String accessKey, String secretKey) {
        defaultAK = accessKey;
        defaultSK = secretKey;
    }

    public static String changeCharset(String result, String OldcharsetName, String charsetName) throws HttpCallerException {
        if (result == null) {
            return result;
        }
        try {
            return new String(result.getBytes(OldcharsetName), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpCallerException(e);
        }
    }

    public static String changeCharset(String result) throws HttpCallerException {
        return HttpCaller.changeCharset(result, "ISO-8859-1", DEFAULT_CHARSET);
    }

    public static String doGet(String requestURL, String apiName, Map<String, String> paramsMap) throws HttpCallerException {
        return HttpCaller.doGet(requestURL, apiName, paramsMap, defaultAK, defaultSK);
    }

    public static String doGet(String requestURL, String apiName, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doGet(requestURL, apiName, null, paramsMap, accessKey, secretKey);
    }

    public static String doGet(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        HttpParameters hp = HttpParameters.newBuilder().requestURL(requestURL).api(apiName).version(version).putParamsMapAll(paramsMap).accessKey(accessKey).secretKey(secretKey).build();
        return HttpCaller.doGet(hp, null, null);
    }

    private static String generateAsEncodeRequestUrl(String requestURL, Map<String, List<String>> urlParamsMap) {
        requestURL = HttpClientHelper.trimUrl(requestURL);
        StringBuffer params = new StringBuffer();
        for (Map.Entry<String, List<String>> kv : urlParamsMap.entrySet()) {
            if (params.length() > 0) {
                params.append("&");
            }
            if (kv.getValue() == null) continue;
            List<String> vlist = kv.getValue();
            for (String v : vlist) {
                params.append(URLEncoder.encode(kv.getKey())).append("=").append(URLEncoder.encode(v));
            }
        }
        String newRequestURL = requestURL;
        if (params.length() > 0) {
            newRequestURL = newRequestURL + "?" + params.toString();
        }
        HttpClientHelper.printDebugInfo("-- requestURL=" + newRequestURL);
        return newRequestURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doGet(HttpParameters hp, StringBuffer resHttpHeaders, Map<String, String> extSignHeadersMap) throws HttpCallerException {
        long startT;
        String requestURL = hp.getRequestUrl();
        String apiName = hp.getApi();
        String version = hp.getVersion();
        Map<String, String> paramsMap = hp.getParamsMap();
        ContentBody cb = hp.getContentBody();
        String accessKey = hp.getAccessKey();
        String secretKey = hp.getSecretkey();
        Map<String, String> directParamsMap = hp.getHeaderParamsMap();
        String restfulProtocolVersion = hp.getRestfulProtocolVersion();
        boolean nonceFlag = hp.isNonce();
        long initT = startT = System.currentTimeMillis();
        HttpClientHelper.validateParams(apiName, accessKey, secretKey, paramsMap);
        Map<String, List<String>> urlParamsMap = HttpClientHelper.parseUrlParamsMap(requestURL, true);
        HttpClientHelper.mergeParams(urlParamsMap, paramsMap, true);
        if (DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("--+++ prepare params costs = " + (System.currentTimeMillis() - startT) + " ms ");
            startT = System.currentTimeMillis();
        }
        HttpCaller.startProcessRestful(requestURL, restfulProtocolVersion, urlParamsMap);
        Map<String, String> headerParamsMap = HttpClientHelper.newParamsMap(urlParamsMap, apiName, version, accessKey, secretKey, hp.isTimestamp(), hp.isNonce(), extSignHeadersMap);
        HttpCaller.endProcessRestful(restfulProtocolVersion, urlParamsMap, headerParamsMap);
        String newRequestURL = HttpCaller.generateAsEncodeRequestUrl(requestURL, urlParamsMap);
        if (HttpCaller.isCurlResponse()) {
            StringBuffer curl = new StringBuffer("curl ");
            curl.append(HttpClientHelper.genCurlHeaders(directParamsMap));
            curl.append(HttpClientHelper.genCurlHeaders(headerParamsMap));
            curl.append(" -k ");
            curl.append("\"").append(newRequestURL).append("\"");
            return curl.toString();
        }
        if (DEBUG.booleanValue()) {
            startT = System.currentTimeMillis();
        }
        HttpGet httpGet = new HttpGet(newRequestURL);
        httpGet.setConfig(HttpCaller.getRequestConfig());
        if (directParamsMap != null) {
            HttpClientHelper.setHeaders(httpGet, directParamsMap);
        }
        HttpClientHelper.setHeaders(httpGet, headerParamsMap);
        if (accessKey != null && DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("-- signature parameters are " + urlParamsMap);
        }
        try {
            String string = HttpCaller.doHttpReq(requestURL, httpGet, resHttpHeaders);
            return string;
        }
        finally {
            if (DEBUG.booleanValue()) {
                HttpClientHelper.printDebugInfo("-- total = " + (System.currentTimeMillis() - initT) + " ms ");
            }
        }
    }

    private static void endProcessRestful(String restfulProtocolVersion, Map<String, List<String>> urlParamsMap, Map<String, String> headerParamsMap) {
        if (DEFAULT_RESTFUL_PROTOCOL_VERSION.equals(restfulProtocolVersion)) {
            urlParamsMap.remove(RESTFUL_PATH_SIGNATURE_KEY);
            headerParamsMap.put(RESTFUL_PROTOCOL_VERION_KEY, DEFAULT_RESTFUL_PROTOCOL_VERSION);
        }
    }

    private static void startProcessRestful(String requestURL, String restfulProtocolVersion, Map<String, List<String>> urlParamsMap) throws HttpCallerException {
        if (DEFAULT_RESTFUL_PROTOCOL_VERSION.equals(restfulProtocolVersion)) {
            String path = HttpClientHelper.getUrlPathInfo(requestURL);
            if (path == null) {
                throw new HttpCallerException("this request is restful but the request path is\u3000null !");
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(path);
            urlParamsMap.put(RESTFUL_PATH_SIGNATURE_KEY, values);
        }
    }

    private static boolean isSSLProtocol(String requestUrl) {
        if (requestUrl == null) {
            return false;
        }
        return requestUrl.trim().toLowerCase().startsWith("https://");
    }

    private static CloseableHttpClient createSyncHttpClient(String requestURL) throws HttpCallerException {
        CloseableHttpClient httpClient = null;
        if (HttpCaller.isSSLProtocol(requestURL)) {
            try {
                httpClient = HttpClients.custom().setSslcontext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build()).setSSLHostnameVerifier(new NoopHostnameVerifier()).build();
            }
            catch (KeyManagementException e) {
                throw new HttpCallerException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HttpCallerException(e);
            }
            catch (KeyStoreException e) {
                throw new HttpCallerException(e);
            }
        } else {
            httpClient = HttpClients.createDefault();
        }
        return httpClient;
    }

    private static CloseableHttpAsyncClient createAsyncHttpClient(String requestURL) throws HttpCallerException {
        CloseableHttpAsyncClient httpClient = null;
        if (HttpCaller.isSSLProtocol(requestURL)) {
            try {
                httpClient = HttpAsyncClients.custom().setSSLHostnameVerifier(new NoopHostnameVerifier()).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    @Override
                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                }).build()).build();
            }
            catch (KeyManagementException e) {
                throw new HttpCallerException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HttpCallerException(e);
            }
            catch (KeyStoreException e) {
                throw new HttpCallerException(e);
            }
        } else {
            httpClient = HttpAsyncClients.createDefault();
        }
        httpClient.start();
        return httpClient;
    }

    public static String doGet(String requestURL) throws HttpCallerException {
        HttpGet httpGet = new HttpGet(requestURL);
        httpGet.setConfig(HttpCaller.getRequestConfig());
        HttpClientHelper.printDebugInfo("requestURL=" + requestURL);
        return HttpCaller.doHttpReq(requestURL, httpGet, null);
    }

    public static String doPost(String requestURL, String apiName, Map<String, String> paramsMap) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, null, paramsMap);
    }

    public static String doPost(String requestURL, String apiName, String version, Map<String, String> paramsMap) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, version, paramsMap, defaultAK, defaultSK);
    }

    public static String doPost(String requestURL, String apiName, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        return HttpCaller.doPost(requestURL, apiName, null, paramsMap, accessKey, secretKey);
    }

    public static String doPost(String requestURL, String apiName, String version, ContentBody cb, String accessKey, String secretKey) throws HttpCallerException {
        HttpParameters hp = HttpParameters.newBuilder().requestURL(requestURL).api(apiName).version(version).contentBody(cb).accessKey(accessKey).secretKey(secretKey).build();
        return HttpCaller.doPost(hp, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(HttpParameters hp, StringBuffer resHttpHeaders, Map<String, String> extSignHeadersMap) throws HttpCallerException {
        String requestURL = hp.getRequestUrl();
        String apiName = hp.getApi();
        String version = hp.getVersion();
        Map<String, String> paramsMap = hp.getParamsMap();
        ContentBody cb = hp.getContentBody();
        String accessKey = hp.getAccessKey();
        String secretKey = hp.getSecretkey();
        Map<String, String> directHheaderParamsMap = hp.getHeaderParamsMap();
        String restfulProtocolVersion = hp.getRestfulProtocolVersion();
        boolean nonceFlag = hp.isNonce();
        long startT = System.currentTimeMillis();
        HttpClientHelper.validateParams(apiName, accessKey, secretKey, paramsMap);
        Map<String, List<String>> urlParamsMap = HttpClientHelper.parseUrlParamsMap(requestURL, true);
        String newRequestURL = HttpCaller.generateAsEncodeRequestUrl(requestURL, urlParamsMap);
        HttpClientHelper.mergeParams(urlParamsMap, paramsMap, false);
        HttpCaller.startProcessRestful(newRequestURL, restfulProtocolVersion, urlParamsMap);
        if (cb != null && cb.getContentType() == ContentBody.Type.JSON && hp.isSignContentBody()) {
            urlParamsMap.put(ContentBody.CONTENT_BODY_SIGN_KEY, Arrays.asList((String)cb.getContentBody()));
        }
        Map<String, String> headerParamsMap = HttpClientHelper.newParamsMap(urlParamsMap, apiName, version, accessKey, secretKey, true, nonceFlag, extSignHeadersMap);
        HttpCaller.endProcessRestful(restfulProtocolVersion, urlParamsMap, headerParamsMap);
        if (HttpCaller.isCurlResponse()) {
            return HttpClientHelper.createPostCurlString(newRequestURL, paramsMap, headerParamsMap, cb, directHheaderParamsMap);
        }
        HttpPost httpPost = HttpClientHelper.createPost(newRequestURL, paramsMap, headerParamsMap, cb);
        HttpClientHelper.setDirectHeaders(httpPost, directHheaderParamsMap);
        httpPost.setConfig(HttpCaller.getRequestConfig());
        if (accessKey != null) {
            HttpClientHelper.printDebugInfo("signature parameters are " + urlParamsMap);
        }
        if (DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("-- prepare time = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        try {
            String string = HttpCaller.doHttpReq(newRequestURL, httpPost, resHttpHeaders);
            return string;
        }
        finally {
            if (DEBUG.booleanValue()) {
                HttpClientHelper.printDebugInfo("-- total = " + (System.currentTimeMillis() - startT) + " ms ");
            }
        }
    }

    private static String doHttpReq(String requestURL, HttpRequestBase httpRequestBase, StringBuffer sb) throws HttpCallerException {
        boolean async = HttpCaller.isAsync();
        if (async) {
            return HttpCaller.doAsyncHttpReq(requestURL, httpRequestBase, sb);
        }
        return HttpCaller.doSyncHttpReq(requestURL, httpRequestBase, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doSyncHttpReq(String requestURL, HttpRequestBase httpRequestBase, StringBuffer resHttpHeaders) throws HttpCallerException {
        String string;
        CloseableHttpClient httpClient;
        long startT;
        block12: {
            if (DEBUG.booleanValue()) {
                HttpClientHelper.printDebugInfo("doSyncHttpReq ");
            }
            startT = System.currentTimeMillis();
            CloseableHttpResponse response = null;
            httpClient = null;
            httpClient = HTTP_CLIENT != null ? HTTP_CLIENT : HttpCaller.createSyncHttpClient(requestURL);
            if (DEBUG.booleanValue()) {
                HttpClientHelper.printDebugInfo("--+++ get httpclient costs = " + (System.currentTimeMillis() - startT) + " ms ");
                startT = System.currentTimeMillis();
            }
            try {
                response = httpClient.execute(httpRequestBase);
                HttpCaller.fetchResHeaders(response, resHttpHeaders);
                string = EntityUtils.toString(response.getEntity());
                if (response == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        response.close();
                    }
                    if (HTTP_CLIENT == null) {
                        httpClient.close();
                    }
                    if (DEBUG.booleanValue()) {
                        HttpClientHelper.printDebugInfo("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new HttpCallerException(e);
                }
            }
            response.close();
        }
        if (HTTP_CLIENT == null) {
            httpClient.close();
        }
        if (DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        return string;
    }

    private static void fetchResHeaders(HttpResponse response, StringBuffer resHttpHeaders) {
        if (response != null && resHttpHeaders != null) {
            StringBuffer body = new StringBuffer();
            for (Header header : response.getAllHeaders()) {
                if (body.length() > 0) {
                    body.append(",");
                }
                body.append(String.format("\"%s\":\"%s\"", header.getName(), header.getValue()));
            }
            resHttpHeaders.setLength(0);
            resHttpHeaders.append(String.format("{%s}", body.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doAsyncHttpReq(String requestURL, HttpRequestBase httpRequestBase, StringBuffer resHttpHeaders) throws HttpCallerException {
        String string;
        if (DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("doAsyncHttpReq ");
        }
        long startT = System.currentTimeMillis();
        HttpResponse response = null;
        CloseableHttpAsyncClient httpClient = HttpCaller.createAsyncHttpClient(requestURL);
        if (DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("--+++ get httpclient costs = " + (System.currentTimeMillis() - startT) + " ms ");
            startT = System.currentTimeMillis();
        }
        try {
            httpClient.start();
            Future<HttpResponse> asyncFuture = httpClient.execute(httpRequestBase, null);
            long waitTime = HttpCaller.getFutureGetTimeOut();
            if (DEBUG.booleanValue()) {
                HttpClientHelper.printDebugInfo("future waitTime :" + waitTime);
            }
            response = waitTime > 0L ? asyncFuture.get(waitTime, TimeUnit.MILLISECONDS) : asyncFuture.get();
            HttpCaller.fetchResHeaders(response, resHttpHeaders);
            string = EntityUtils.toString(response.getEntity());
        }
        catch (Throwable throwable) {
            try {
                httpClient.close();
                if (DEBUG.booleanValue()) {
                    HttpClientHelper.printDebugInfo("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new HttpCallerException(e);
            }
        }
        httpClient.close();
        if (DEBUG.booleanValue()) {
            HttpClientHelper.printDebugInfo("-- http req & resp time = " + (System.currentTimeMillis() - startT) + " ms ");
        }
        return string;
    }

    public static String doPost(String requestURL, String apiName, String version, Map<String, String> paramsMap, String accessKey, String secretKey) throws HttpCallerException {
        HttpParameters hp = HttpParameters.newBuilder().requestURL(requestURL).api(apiName).version(version).putParamsMapAll(paramsMap).accessKey(accessKey).secretKey(secretKey).build();
        return HttpCaller.doPost(hp, null, null);
    }

    public static String invoke(HttpParameters hp, StringBuffer resHttpHeaders) throws HttpCallerException {
        if (hp == null) {
            throw new IllegalArgumentException("null parameter!");
        }
        HttpClientHelper.printDebugInfo("-- httpParameters=" + hp.toString());
        hp.validate();
        HashMap<String, String> extSignHeaders = new HashMap<String, String>();
        if ("POST".equalsIgnoreCase(hp.getMethod()) || "CPOST".equalsIgnoreCase(hp.getMethod())) {
            return HttpCaller.doPost(hp, resHttpHeaders, extSignHeaders);
        }
        return HttpCaller.doGet(hp, resHttpHeaders, extSignHeaders);
    }

    public static String invoke(HttpParameters hp) throws HttpCallerException {
        return HttpCaller.invoke(hp, null);
    }

    public static byte[] readFileAsByteArray(String file) throws HttpCallerException {
        File f = new File(file);
        if (f.exists() && f.isFile() && f.canRead()) {
            if (f.length() > 0xA00000L) {
                throw new HttpCallerException("file is too large exceed the MAX-SIZE: 10M");
            }
            FileInputStream ios = null;
            ByteArrayOutputStream bos = null;
            byte[] buffer = null;
            try {
                int n;
                ios = new FileInputStream(file);
                bos = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                while ((n = ((InputStream)ios).read(b)) != -1) {
                    bos.write(b, 0, n);
                }
                buffer = bos.toByteArray();
            }
            catch (IOException e) {
                throw new HttpCallerException(e);
            }
            finally {
                try {
                    if (ios != null) {
                        ((InputStream)ios).close();
                    }
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return buffer;
        }
        throw new HttpCallerException("bad file to read:" + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoveryFileFromBytes(byte[] body, String filePath, String fileName) throws HttpCallerException {
        try {
            String fileFullPath = filePath;
            fileFullPath = fileFullPath.endsWith("/") ? fileFullPath + fileName : fileFullPath + "/" + fileName;
            File f = new File(fileFullPath);
            FileOutputStream out = new FileOutputStream(f);
            try {
                out.write(body, 0, body.length);
                out.flush();
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new HttpCallerException(e);
        }
    }

    public static boolean isAsync() {
        boolean async = false;
        String asyncConf = System.getProperty("http.caller.connection.async");
        if (asyncConf != null && asyncConf.length() > 0) {
            async = Boolean.valueOf(asyncConf);
        }
        return async;
    }

    public static long getFutureGetTimeOut() {
        int connTimeOut;
        int crTimeOut;
        RequestConfig requestConfig = HttpCaller.getRequestConfig();
        long waitTime = 0L;
        int socketTimeOUt = requestConfig.getSocketTimeout();
        if (socketTimeOUt > 0) {
            waitTime += (long)socketTimeOUt;
        }
        if ((crTimeOut = requestConfig.getConnectionRequestTimeout()) > 0) {
            waitTime += (long)crTimeOut;
        }
        if ((connTimeOut = requestConfig.getConnectTimeout()) > 0) {
            waitTime += (long)connTimeOut;
        }
        return (long)((double)waitTime * 1.1);
    }

    static {
        block7: {
            warmupFlag = false;
            HTTP_CLIENT = null;
            connMgr = null;
            DEBUG = Boolean.getBoolean("http.caller.DEBUG");
            SKIP_CONN_POOL = Boolean.getBoolean("http.caller.skip.connection.pool");
            VALIDATE_PERIOD = Integer.getInteger("http.caller.connection.validate.span", 100);
            CLEAN_PERIOD = Integer.getInteger("http.caller.connection.clean.span", 5000);
            SUPPORTED_CONNECTION_PARAMS = Arrays.asList("http.caller.connection.max", "http.caller.connection.timeout", "http.caller.connection.so.timeout", "http.caller.connection.cr.timeout", "http.caller.connection.async");
            trustCA = System.getProperty("http.caller.ssl.trustca");
            defaultAK = null;
            defaultSK = null;
            toCurlCmd = new ThreadLocal();
            proxyConfigThreadLocal = new ThreadLocal();
            requestConfigBuilder = HttpCaller.createConnBuilder();
            requestConfigBuilderLocal = new ThreadLocal();
            try {
                if (!SKIP_CONN_POOL.booleanValue()) {
                    connMgr = HttpClientFactory.createConnManager();
                    String maxConn = System.getProperty(SUPPORTED_CONNECTION_PARAMS.get(0));
                    if (maxConn != null) {
                        try {
                            int imaxConn = Integer.parseInt(maxConn);
                            connMgr.setMaxTotal(imaxConn);
                            connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
                        }
                        catch (Exception e) {
                            throw new HttpCallerException(String.format("[ERROR] CSB-SDK failed to create connection pool with %d connections", maxConn));
                        }
                    }
                    connMgr.setValidateAfterInactivity(VALIDATE_PERIOD);
                    HTTP_CLIENT = HttpClientFactory.createCloseableHttpClient(connMgr);
                    IdleConnectionMonitorThread clearThread = new IdleConnectionMonitorThread(connMgr);
                    clearThread.setDaemon(true);
                    clearThread.start();
                    break block7;
                }
                if (DEBUG.booleanValue()) {
                    System.out.println("[WARNING] skip using connection pool");
                }
            }
            catch (HttpCallerException e) {
                HTTP_CLIENT = null;
                System.out.println("[WARNING] failed to create a pooled http client with the error : " + e.getMessage());
                if (!DEBUG.booleanValue()) break block7;
                e.printStackTrace(System.out);
            }
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(CLEAN_PERIOD);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

