/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csb.sdk;

import com.alibaba.csb.sdk.CmdCaller;
import com.alibaba.csb.sdk.CommUtil;
import com.alibaba.csb.sdk.ContentBody;
import com.alibaba.csb.sdk.HttpCaller;
import com.alibaba.csb.sdk.HttpParameters;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class CmdHttpCaller {
    private static final String SDK_VERSION = "1.1.4";
    public static Options opt = new Options();

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static void main(String[] args) {
        block25: {
            DefaultParser parser = new DefaultParser();
            Boolean isDebug = false;
            try {
                String[] kv;
                CommandLine commandline = parser.parse(opt, args);
                if (commandline.getOptions().length == 0 && commandline.getArgs().length > 0) {
                    CmdCaller.main(args);
                    return;
                }
                if (commandline.hasOption("h")) {
                    CmdHttpCaller.usage(null);
                    return;
                }
                String ak = commandline.getOptionValue("ak");
                String sk = commandline.getOptionValue("sk");
                String api = commandline.getOptionValue("api");
                String version = commandline.getOptionValue("version");
                String method = commandline.getOptionValue("method");
                String[] headers = commandline.getOptionValues("H");
                String[] params = commandline.getOptionValues("D");
                String url = commandline.getOptionValue("url");
                String proxy = commandline.getOptionValue("proxy");
                String cbJSON = commandline.getOptionValue("cbJSON");
                boolean nonce = commandline.hasOption("nonce");
                isDebug = commandline.hasOption("d");
                if (isDebug.booleanValue()) {
                    System.out.println("url=" + url);
                    System.out.println("api=" + api);
                    System.out.println("version=" + version);
                    System.out.println("ak=" + ak);
                    System.out.println("sk=" + sk);
                    System.out.println("proxy=" + proxy);
                    System.out.println("nonce=" + nonce);
                    CmdHttpCaller.printKV("HTTP Headers", headers);
                    CmdHttpCaller.printKV("HTTP Params", params);
                }
                if (CmdHttpCaller.isEmpty(api)) {
                    CmdHttpCaller.usage("\u8bf7\u5b9a\u4e49 -api \u53c2\u6570");
                    return;
                }
                if (CmdHttpCaller.isEmpty(version)) {
                    CmdHttpCaller.usage("\u8bf7\u5b9a\u4e49 -version \u53c2\u6570");
                    return;
                }
                if (CmdHttpCaller.isEmpty(url)) {
                    CmdHttpCaller.usage("\u8bf7\u5b9a\u4e49 -url \u53c2\u6570");
                    return;
                }
                if (method == null) {
                    method = "get";
                }
                HttpParameters.Builder builder = HttpParameters.newBuilder();
                builder.api(api).version(version).method(method).requestURL(url).accessKey(ak).secretKey(sk);
                if (headers != null) {
                    for (String header : headers) {
                        kv = header.split(":", 2);
                        if (kv == null || kv.length != 2) {
                            System.out.println("\u9519\u8bef\u7684HTTP\u5934\u5b9a\u4e49 \u6b63\u786e\u683c\u5f0f: -H \"key:value\" !!" + header);
                            return;
                        }
                        builder.putHeaderParamsMap(kv[0], kv[1]);
                    }
                }
                if (params != null) {
                    for (String param : params) {
                        kv = param.split("=", 2);
                        if (kv == null || kv.length != 2) {
                            System.out.println("\u9519\u8bef\u7684\u53c2\u6570\u5bf9\u5b9a\u4e49 \u6b63\u786e\u683c\u5f0f: -D \"key=value\" !!" + param);
                            return;
                        }
                        builder.putParamsMap(kv[0], kv[1]);
                    }
                }
                if (cbJSON != null) {
                    if ("cget".equalsIgnoreCase(method) || "cget".equalsIgnoreCase(method)) {
                        System.out.println("\u5f53\u5b9a\u4e49-cbJSON\u8bf7\u6c42\u53c2\u6570\u65f6\uff0c -method \u5fc5\u987b\u4e3apost\u65b9\u5f0f!");
                        return;
                    }
                    builder.contentBody(new ContentBody(cbJSON));
                }
                builder.nonce(nonce);
                boolean curlOnly = false;
                if (method.toLowerCase().startsWith("c")) {
                    curlOnly = true;
                    HttpCaller.setCurlResponse(true);
                }
                StringBuffer resHttpHeaders = new StringBuffer();
                if (proxy != null) {
                    String errMsg = String.format("\u9519\u8bef\u7684proxy\u4ee3\u7406\u8bbe\u7f6e %s \u6b63\u786e\u683c\u5f0f: -proxy \"proxy_host:proxy_port\" !!", proxy);
                    String[] pcs = proxy.split(":");
                    if (pcs == null || pcs.length != 2) {
                        System.out.println(errMsg);
                        return;
                    }
                    try {
                        HttpCaller.setProxyHost(pcs[0], Integer.parseInt(pcs[1]), null);
                    }
                    catch (Exception e) {
                        System.out.println(errMsg);
                        return;
                    }
                }
                String ret = HttpCaller.invoke(builder.build(), resHttpHeaders);
                if (curlOnly) {
                    System.out.println("---- curlString = " + ret);
                } else {
                    System.out.println("---- response http headers = " + resHttpHeaders.toString());
                    System.out.println("---- retStr = " + ret);
                    System.out.println("\n---- retStr after changeCharset = " + HttpCaller.changeCharset(ret));
                    int times = Integer.getInteger("test.stress.times", 0);
                    for (int i = 2; i <= times; ++i) {
                        ret = HttpCaller.invoke(builder.build(), null);
                        System.out.println("---- retStr [#" + i + "] = " + ret);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("-- \u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
                if (!isDebug.booleanValue()) break block25;
                e.printStackTrace(System.out);
            }
        }
    }

    private static void printKV(String title, String[] kvs) {
        if (kvs != null) {
            System.out.println("---- " + title + " ----");
            for (String kv : kvs) {
                System.out.print(kv);
            }
            System.out.println("---- ---- ----");
        }
    }

    static void usage(String message) {
        if (message != null) {
            System.out.println("\u53c2\u6570\u9519\u8bef:" + message);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar http-client.jar [options...]", opt);
        System.out.println("\ncurrent SDK version:1.1.4\n----");
        try {
            System.out.println(CommUtil.geCurrenttVersionFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        opt.addOption("url", true, "\u8bf7\u6c42\u5730\u5740\uff0ce.g: http://broker-ip:8086/CSB?p1=v1");
        opt.addOption("api", true, "\u670d\u52a1\u540d");
        opt.addOption("version", true, "\u670d\u52a1\u7248\u672c");
        opt.addOption("ak", true, "accessKey, \u53ef\u9009");
        opt.addOption("sk", true, "secretKey, \u53ef\u9009");
        opt.addOption("method", true, "\u8bf7\u6c42\u7c7b\u578b, \u9ed8\u8ba4get, \u53ef\u9009\u7684\u503c\u4e3a: get, post, cget\u548ccpost");
        opt.addOption("proxy", true, "\u8bbe\u7f6e\u4ee3\u7406\u5730\u5740, \u683c\u5f0f: proxy_hostname:proxy_port ");
        opt.addOption("H", true, "http header, \u683c\u5f0f: -H \"key:value\"");
        opt.addOption("D", true, "\u8bf7\u6c42\u53c2\u6570, \u683c\u5f0f: -D \"key=value\"");
        opt.addOption("cbJSON", true, "\u4ee5JSON\u4e32\u65b9\u5f0fpost\u53d1\u9001\u7684\u8bf7\u6c42body, \u4f8b\u5982: -cbJSON '{\"name\":\"wiseking\"}'");
        opt.addOption("nonce", false, "-nonce \u662f\u5426\u505anonce\u9632\u91cd\u653e\u5904\u7406\uff0c\u4e0d\u5b9a\u4e49\u4e3a\u4e0d\u505anonce\u91cd\u653e\u5904\u7406");
        opt.addOption("h", "help", false, "\u6253\u5370\u5e2e\u52a9\u4fe1\u606f");
        opt.addOption("d", "debug", false, "\u6253\u5370\u8c03\u8bd5\u4fe1\u606f");
    }
}

