/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;

public class JDBCHelper {
    private static final String SQL_PATTERN = "SELECT {},{} FROM {} WHERE {}=?";
    private static final String SCRIPT_SQL_CHECK_PATTERN = "SELECT 1 FROM {} WHERE {}=?";
    private static final String SCRIPT_SQL_PATTERN = "SELECT {},{},{},{} FROM {} WHERE {}=?";
    private static final String CHAIN_XML_PATTERN = "<chain name=\"{}\">{}</chain>";
    private static final String NODE_XML_PATTERN = "<nodes>{}</nodes>";
    private static final String NODE_ITEM_XML_PATTERN = "<node id=\"{}\" name=\"{}\" type=\"{}\"><![CDATA[{}]]></node>";
    private static final String XML_PATTERN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><flow>{}{}</flow>";
    private static final Integer FETCH_SIZE_MAX = 1000;
    private SQLParserVO sqlParserVO;
    private static JDBCHelper INSTANCE;

    public static void init(SQLParserVO sqlParserVO) {
        try {
            INSTANCE = new JDBCHelper();
            Class.forName(sqlParserVO.getDriverClassName());
            INSTANCE.setSqlParserVO(sqlParserVO);
        }
        catch (ClassNotFoundException e) {
            throw new ELSQLException(e.getMessage());
        }
    }

    public static JDBCHelper getInstance() {
        return INSTANCE;
    }

    public Connection getConn() {
        Connection connection;
        try {
            connection = DriverManager.getConnection(this.sqlParserVO.getUrl(), this.sqlParserVO.getUsername(), this.sqlParserVO.getPassword());
        }
        catch (SQLException e) {
            throw new ELSQLException(e.getMessage());
        }
        return connection;
    }

    public String getContent() {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String chainTableName = this.sqlParserVO.getChainTableName();
        String elDataField = this.sqlParserVO.getElDataField();
        String chainNameField = this.sqlParserVO.getChainNameField();
        String chainApplicationNameField = this.sqlParserVO.getChainApplicationNameField();
        String applicationName = this.sqlParserVO.getApplicationName();
        if (StrUtil.isBlank((CharSequence)chainTableName)) {
            throw new ELSQLException("You did not define the chainTableName property");
        }
        if (StrUtil.isBlank((CharSequence)applicationName) || StrUtil.isBlank((CharSequence)chainApplicationNameField)) {
            throw new ELSQLException("You did not define the applicationName or chainApplicationNameField property");
        }
        String sqlCmd = StrUtil.format((CharSequence)SQL_PATTERN, (Object[])new Object[]{chainNameField, elDataField, chainTableName, chainApplicationNameField});
        ArrayList<String> result = new ArrayList<String>();
        try {
            conn = this.getConn();
            stmt = conn.prepareStatement(sqlCmd, 1003, 1007);
            stmt.setFetchSize(FETCH_SIZE_MAX);
            stmt.setString(1, applicationName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String elData = this.getStringFromResultSet(rs, elDataField);
                String chainName = this.getStringFromResultSet(rs, chainNameField);
                result.add(StrUtil.format((CharSequence)CHAIN_XML_PATTERN, (Object[])new Object[]{chainName, elData}));
            }
            this.close(conn, stmt, rs);
        }
        catch (Exception e) {
            try {
                throw new ELSQLException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(conn, stmt, rs);
                throw throwable;
            }
        }
        String chainsContent = CollUtil.join(result, (CharSequence)"");
        String nodesContent = this.hasScriptData() ? this.getScriptNodes() : "";
        return StrUtil.format((CharSequence)XML_PATTERN, (Object[])new Object[]{nodesContent, chainsContent});
    }

    public String getScriptNodes() {
        ArrayList<String> result = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String scriptTableName = this.sqlParserVO.getScriptTableName();
        String scriptIdField = this.sqlParserVO.getScriptIdField();
        String scriptDataField = this.sqlParserVO.getScriptDataField();
        String scriptNameField = this.sqlParserVO.getScriptNameField();
        String scriptTypeField = this.sqlParserVO.getScriptTypeField();
        String scriptApplicationNameField = this.sqlParserVO.getScriptApplicationNameField();
        String applicationName = this.sqlParserVO.getApplicationName();
        if (StrUtil.isBlank((CharSequence)applicationName) || StrUtil.isBlank((CharSequence)scriptApplicationNameField)) {
            throw new ELSQLException("You did not define the applicationName or scriptApplicationNameField property");
        }
        String sqlCmd = StrUtil.format((CharSequence)SCRIPT_SQL_PATTERN, (Object[])new Object[]{scriptIdField, scriptDataField, scriptNameField, scriptTypeField, scriptTableName, scriptApplicationNameField});
        try {
            conn = this.getConn();
            stmt = conn.prepareStatement(sqlCmd, 1003, 1007);
            stmt.setFetchSize(FETCH_SIZE_MAX);
            stmt.setString(1, applicationName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String id = this.getStringFromResultSet(rs, scriptIdField);
                String data = this.getStringFromResultSet(rs, scriptDataField);
                String name = this.getStringFromResultSet(rs, scriptNameField);
                String type = this.getStringFromResultSet(rs, scriptTypeField);
                NodeTypeEnum nodeTypeEnum = NodeTypeEnum.getEnumByCode((String)type);
                if (Objects.isNull(nodeTypeEnum)) {
                    throw new ELSQLException(StrUtil.format((CharSequence)"Invalid type value[{}]", (Object[])new Object[]{type}));
                }
                if (!nodeTypeEnum.isScript()) {
                    throw new ELSQLException(StrUtil.format((CharSequence)"The type value[{}] is not a script type", (Object[])new Object[]{type}));
                }
                result.add(StrUtil.format((CharSequence)NODE_ITEM_XML_PATTERN, (Object[])new Object[]{id, name, type, data}));
            }
            this.close(conn, stmt, rs);
        }
        catch (Exception e) {
            try {
                throw new ELSQLException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(conn, stmt, rs);
                throw throwable;
            }
        }
        return StrUtil.format((CharSequence)NODE_XML_PATTERN, (Object[])new Object[]{CollUtil.join(result, (CharSequence)"")});
    }

    private void close(Connection conn, PreparedStatement stmt, ResultSet rs) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e.getMessage());
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e.getMessage());
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasScriptData() {
        if (StrUtil.isBlank((CharSequence)this.sqlParserVO.getScriptTableName())) {
            return false;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sqlCmd = StrUtil.format((CharSequence)SCRIPT_SQL_CHECK_PATTERN, (Object[])new Object[]{this.sqlParserVO.getScriptTableName(), this.sqlParserVO.getScriptApplicationNameField()});
        try {
            conn = this.getConn();
            stmt = conn.prepareStatement(sqlCmd, 1003, 1007);
            stmt.setFetchSize(1);
            stmt.setString(1, this.sqlParserVO.getApplicationName());
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            this.close(conn, stmt, rs);
            return bl;
        }
        catch (Exception e) {
            try {
                boolean bl = false;
                this.close(conn, stmt, rs);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(conn, stmt, rs);
                throw throwable;
            }
        }
    }

    private String getStringFromResultSet(ResultSet rs, String field) throws SQLException {
        String data = rs.getString(field);
        if (StrUtil.isBlank((CharSequence)data)) {
            throw new ELSQLException(StrUtil.format((CharSequence)"exist {} field value is empty", (Object[])new Object[]{field}));
        }
        return data;
    }

    private SQLParserVO getSqlParserVO() {
        return this.sqlParserVO;
    }

    private void setSqlParserVO(SQLParserVO sqlParserVO) {
        this.sqlParserVO = sqlParserVO;
    }
}

