/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.el.ClassXmlFlowELParser;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.util.JDBCHelper;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.property.LiteflowConfigGetter;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.Map;
import java.util.Objects;

public class SQLXmlELParser
extends ClassXmlFlowELParser {
    private static final String ERROR_MSG_PATTERN = "rule-source-ext-data {} is blank";
    private static final String ERROR_COMMON_MSG = "rule-source-ext-data is empty";

    public SQLXmlELParser() {
        LiteflowConfig liteflowConfig = LiteflowConfigGetter.get();
        try {
            SQLParserVO sqlParserVO = null;
            if (MapUtil.isNotEmpty((Map)liteflowConfig.getRuleSourceExtDataMap())) {
                sqlParserVO = (SQLParserVO)BeanUtil.toBean((Object)liteflowConfig.getRuleSourceExtDataMap(), SQLParserVO.class, (CopyOptions)CopyOptions.create());
            } else if (StrUtil.isNotBlank((CharSequence)liteflowConfig.getRuleSourceExtData())) {
                sqlParserVO = (SQLParserVO)JsonUtil.parseObject((String)liteflowConfig.getRuleSourceExtData(), SQLParserVO.class);
            }
            if (Objects.isNull(sqlParserVO)) {
                throw new ELSQLException(ERROR_COMMON_MSG);
            }
            this.checkParserVO(sqlParserVO);
            JDBCHelper.init(sqlParserVO);
        }
        catch (ELSQLException elsqlException) {
            throw elsqlException;
        }
        catch (Exception ex) {
            throw new ELSQLException(ex.getMessage());
        }
    }

    public String parseCustom() {
        return JDBCHelper.getInstance().getContent();
    }

    private void checkParserVO(SQLParserVO sqlParserVO) {
        if (StrUtil.isEmpty((CharSequence)sqlParserVO.getUrl())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"url"}));
        }
        if (StrUtil.isEmpty((CharSequence)sqlParserVO.getDriverClassName())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"driverClassName"}));
        }
        if (Objects.isNull(sqlParserVO.getUsername())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"username"}));
        }
        if (Objects.isNull(sqlParserVO.getPassword())) {
            throw new ELSQLException(StrFormatter.format((String)ERROR_MSG_PATTERN, (Object[])new Object[]{"password"}));
        }
    }
}

