/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.nacos.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.client.config.NacosConfigService;
import com.yomahub.liteflow.exception.ParseException;
import com.yomahub.liteflow.parser.nacos.exception.NacosException;
import com.yomahub.liteflow.parser.nacos.vo.NacosParserVO;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosParserHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NacosParserHelper.class);
    private final NacosParserVO nacosParserVO;
    private NacosConfigService configService;

    public NacosParserHelper(NacosParserVO nacosParserVO) {
        this.nacosParserVO = nacosParserVO;
        try {
            try {
                this.configService = (NacosConfigService)ContextAwareHolder.loadContextAware().getBean(NacosConfigService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.configService == null) {
                Properties properties = new Properties();
                properties.put("serverAddr", nacosParserVO.getServerAddr());
                properties.put("namespace", nacosParserVO.getNamespace());
                properties.put("username", nacosParserVO.getUsername());
                properties.put("password", nacosParserVO.getPassword());
                this.configService = new NacosConfigService(properties);
            }
        }
        catch (Exception e) {
            throw new NacosException(e.getMessage());
        }
    }

    public String getContent() {
        try {
            return this.configService.getConfig(this.nacosParserVO.getDataId(), this.nacosParserVO.getGroup(), 3000L);
        }
        catch (Exception e) {
            throw new NacosException(e.getMessage());
        }
    }

    public void checkContent(String content) {
        if (StrUtil.isBlank((CharSequence)content)) {
            String error = StrUtil.format((CharSequence)"the node[{}] value is empty", (Object[])new Object[]{this.nacosParserVO.toString()});
            throw new ParseException(error);
        }
    }

    public void listener(final Consumer<String> parseConsumer) {
        try {
            this.configService.addListener(this.nacosParserVO.getDataId(), this.nacosParserVO.getGroup(), new Listener(){

                public void receiveConfigInfo(String configInfo) {
                    LOG.info("stating load flow config.... {} ", (Object)configInfo);
                    parseConsumer.accept(configInfo);
                }

                public Executor getExecutor() {
                    return null;
                }
            });
        }
        catch (Exception ex) {
            throw new NacosException(ex.getMessage());
        }
    }
}

