/*
 * Decompiled with CFR 0.152.
 */
package push;

import org.json.JSONArray;
import org.json.JSONObject;
import push.AndroidNotification;
import push.PushClient;
import push.android.AndroidBroadcast;
import push.android.AndroidCustomizedcast;
import push.android.AndroidFilecast;
import push.android.AndroidGroupcast;
import push.android.AndroidUnicast;
import push.ios.IOSBroadcast;
import push.ios.IOSCustomizedcast;
import push.ios.IOSFilecast;
import push.ios.IOSGroupcast;
import push.ios.IOSUnicast;

public class Demo {
    private String appkey = null;
    private String appMasterSecret = null;
    private String timestamp = null;
    private PushClient client = new PushClient();

    public Demo(String key, String secret) {
        try {
            this.appkey = key;
            this.appMasterSecret = secret;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void sendAndroidBroadcast() throws Exception {
        AndroidBroadcast broadcast = new AndroidBroadcast(this.appkey, this.appMasterSecret);
        broadcast.setTicker("Android broadcast ticker");
        broadcast.setTitle("\u4e2d\u6587\u7684title");
        broadcast.setText("Android broadcast text");
        broadcast.goAppAfterOpen();
        broadcast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        broadcast.setProductionMode();
        broadcast.setExtraField("test", "helloworld");
        this.client.send(broadcast);
    }

    public void sendAndroidUnicast() throws Exception {
        AndroidUnicast unicast = new AndroidUnicast(this.appkey, this.appMasterSecret);
        unicast.setDeviceToken("your device token");
        unicast.setTicker("Android unicast ticker");
        unicast.setTitle("\u4e2d\u6587\u7684title");
        unicast.setText("Android unicast text");
        unicast.goAppAfterOpen();
        unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        unicast.setProductionMode();
        unicast.setExtraField("test", "helloworld");
        this.client.send(unicast);
    }

    public void sendAndroidGroupcast() throws Exception {
        AndroidGroupcast groupcast = new AndroidGroupcast(this.appkey, this.appMasterSecret);
        JSONObject filterJson = new JSONObject();
        JSONObject whereJson = new JSONObject();
        JSONArray tagArray = new JSONArray();
        JSONObject testTag = new JSONObject();
        JSONObject TestTag = new JSONObject();
        testTag.put("tag", "test");
        TestTag.put("tag", "Test");
        tagArray.put(testTag);
        tagArray.put(TestTag);
        whereJson.put("and", tagArray);
        filterJson.put("where", whereJson);
        System.out.println(filterJson.toString());
        groupcast.setFilter(filterJson);
        groupcast.setTicker("Android groupcast ticker");
        groupcast.setTitle("\u4e2d\u6587\u7684title");
        groupcast.setText("Android groupcast text");
        groupcast.goAppAfterOpen();
        groupcast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        groupcast.setProductionMode();
        this.client.send(groupcast);
    }

    public void sendAndroidCustomizedcast() throws Exception {
        AndroidCustomizedcast customizedcast = new AndroidCustomizedcast(this.appkey, this.appMasterSecret);
        customizedcast.setAlias("alias", "alias_type");
        customizedcast.setTicker("Android customizedcast ticker");
        customizedcast.setTitle("\u4e2d\u6587\u7684title");
        customizedcast.setText("Android customizedcast text");
        customizedcast.goAppAfterOpen();
        customizedcast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        customizedcast.setProductionMode();
        this.client.send(customizedcast);
    }

    public void sendAndroidCustomizedcastFile() throws Exception {
        AndroidCustomizedcast customizedcast = new AndroidCustomizedcast(this.appkey, this.appMasterSecret);
        String fileId = this.client.uploadContents(this.appkey, this.appMasterSecret, "aa\nbb\nalias");
        customizedcast.setFileId(fileId, "alias_type");
        customizedcast.setTicker("Android customizedcast ticker");
        customizedcast.setTitle("\u4e2d\u6587\u7684title");
        customizedcast.setText("Android customizedcast text");
        customizedcast.goAppAfterOpen();
        customizedcast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        customizedcast.setProductionMode();
        this.client.send(customizedcast);
    }

    public void sendAndroidFilecast() throws Exception {
        AndroidFilecast filecast = new AndroidFilecast(this.appkey, this.appMasterSecret);
        String fileId = this.client.uploadContents(this.appkey, this.appMasterSecret, "aa\nbb");
        filecast.setFileId(fileId);
        filecast.setTicker("Android filecast ticker");
        filecast.setTitle("\u4e2d\u6587\u7684title");
        filecast.setText("Android filecast text");
        filecast.goAppAfterOpen();
        filecast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        this.client.send(filecast);
    }

    public void sendIOSBroadcast() throws Exception {
        IOSBroadcast broadcast = new IOSBroadcast(this.appkey, this.appMasterSecret);
        broadcast.setAlert("IOS \u5e7f\u64ad\u6d4b\u8bd5");
        broadcast.setBadge(0);
        broadcast.setSound("default");
        broadcast.setTestMode();
        broadcast.setCustomizedField("test", "helloworld");
        this.client.send(broadcast);
    }

    public void sendIOSUnicast() throws Exception {
        IOSUnicast unicast = new IOSUnicast(this.appkey, this.appMasterSecret);
        unicast.setDeviceToken("xx");
        unicast.setAlert("IOS \u5355\u64ad\u6d4b\u8bd5");
        unicast.setBadge(0);
        unicast.setSound("default");
        unicast.setTestMode();
        unicast.setCustomizedField("test", "helloworld");
        this.client.send(unicast);
    }

    public void sendIOSGroupcast() throws Exception {
        IOSGroupcast groupcast = new IOSGroupcast(this.appkey, this.appMasterSecret);
        JSONObject filterJson = new JSONObject();
        JSONObject whereJson = new JSONObject();
        JSONArray tagArray = new JSONArray();
        JSONObject testTag = new JSONObject();
        testTag.put("tag", "iostest");
        tagArray.put(testTag);
        whereJson.put("and", tagArray);
        filterJson.put("where", whereJson);
        System.out.println(filterJson.toString());
        groupcast.setFilter(filterJson);
        groupcast.setAlert("IOS \u7ec4\u64ad\u6d4b\u8bd5");
        groupcast.setBadge(0);
        groupcast.setSound("default");
        groupcast.setTestMode();
        this.client.send(groupcast);
    }

    public void sendIOSCustomizedcast() throws Exception {
        IOSCustomizedcast customizedcast = new IOSCustomizedcast(this.appkey, this.appMasterSecret);
        customizedcast.setAlias("alias", "alias_type");
        customizedcast.setAlert("IOS \u4e2a\u6027\u5316\u6d4b\u8bd5");
        customizedcast.setBadge(0);
        customizedcast.setSound("default");
        customizedcast.setTestMode();
        this.client.send(customizedcast);
    }

    public void sendIOSFilecast() throws Exception {
        IOSFilecast filecast = new IOSFilecast(this.appkey, this.appMasterSecret);
        String fileId = this.client.uploadContents(this.appkey, this.appMasterSecret, "aa\nbb");
        filecast.setFileId(fileId);
        filecast.setAlert("IOS \u6587\u4ef6\u64ad\u6d4b\u8bd5");
        filecast.setBadge(0);
        filecast.setSound("default");
        filecast.setTestMode();
        this.client.send(filecast);
    }

    public static void main(String[] args) {
        Demo demo = new Demo("your appkey", "the app master secret");
        try {
            demo.sendAndroidUnicast();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

