package com.theproject.kit.actuator.dubbo.prometheus.binder.bean;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.store.DataStore;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboThreadPoolStatusBinderBean {

    public DubboThreadPoolStatusVO getDubboThreadPoolStatus(){
        DataStore dataStore = ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
        Map<String, Object> executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);

        StringBuilder msg = new StringBuilder();
        Status.Level level = Status.Level.OK;

        DubboThreadPoolStatusVO dubboThreadPoolStatusVO = null;

        for(Map.Entry<String, Object> entry : executors.entrySet()) {
            String port = entry.getKey();
            ExecutorService executor = (ExecutorService) entry.getValue();

            if (executor != null && executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tp = (ThreadPoolExecutor) executor;
                boolean ok = tp.getActiveCount() < tp.getMaximumPoolSize() - 1;
                Status.Level lvl = Status.Level.OK;
                if(!ok) {
                    level = Status.Level.WARN;
                    lvl = Status.Level.WARN;
                }

                dubboThreadPoolStatusVO = new DubboThreadPoolStatusVO();
                dubboThreadPoolStatusVO.setMaximumPoolSize(tp.getMaximumPoolSize());
                dubboThreadPoolStatusVO.setCorePoolSize(tp.getCorePoolSize());
                dubboThreadPoolStatusVO.setActiveCount(tp.getActiveCount());
                dubboThreadPoolStatusVO.setTaskCount(tp.getTaskCount());
                dubboThreadPoolStatusVO.setCompletedTaskCount(tp.getCompletedTaskCount());
            }
        }

        return dubboThreadPoolStatusVO;
    }


    public class DubboThreadPoolStatusVO{

        private int maximumPoolSize;

        private int corePoolSize;

        private int largestPoolSize;

        private int activeCount;

        private long taskCount;

        private long completedTaskCount;

        public int getMaximumPoolSize() {
            return maximumPoolSize;
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public int getCorePoolSize() {
            return corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getLargestPoolSize() {
            return largestPoolSize;
        }

        public void setLargestPoolSize(int largestPoolSize) {
            this.largestPoolSize = largestPoolSize;
        }

        public int getActiveCount() {
            return activeCount;
        }

        public void setActiveCount(int activeCount) {
            this.activeCount = activeCount;
        }

        public long getTaskCount() {
            return taskCount;
        }

        public void setTaskCount(long taskCount) {
            this.taskCount = taskCount;
        }

        public long getCompletedTaskCount() {
            return completedTaskCount;
        }

        public void setCompletedTaskCount(long completedTaskCount) {
            this.completedTaskCount = completedTaskCount;
        }
    }
}
