/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.theproject.kit.actuator.dubbo.autoconfigure;

import com.theproject.kit.actuator.dubbo.prometheus.binder.DubboHealthBinder;
import com.theproject.kit.actuator.dubbo.prometheus.binder.DubboInvokeHealthBinder;
import com.theproject.kit.actuator.dubbo.prometheus.binder.DubboInvokeAlertCounterBinder;
import com.theproject.kit.actuator.dubbo.prometheus.binder.DubboThreadPoolStatusBinder;
import com.theproject.kit.actuator.dubbo.prometheus.binder.bean.DubboHealthBinderBean;
import com.theproject.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeAlertCounterBinderBean;
import com.theproject.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeHealthBinderBean;
import com.theproject.kit.actuator.dubbo.prometheus.binder.bean.DubboThreadPoolStatusBinderBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(name = {
        "org.springframework.boot.actuate.health.Health"
})
@ConditionalOnProperty(name = "management.health.dubbo.enabled", matchIfMissing = true, havingValue = "true")
@PropertySource(
        name = "Dubbo Endpoints Default Properties",
        value = "classpath:/META-INF/dubbo-endpoints-default.properties")
public class DubboHealthBinderAutoConfiguration {

    /*@Bean
    @ConditionalOnMissingBean
    public DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean() {
        return new DubboInvokeHealthBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeHealthBinder dubboInvokeHealthBinder(DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean) {
        return new DubboInvokeHealthBinder(dubboInvokeHealthBinderBean);
    }*/

    @Bean
    @ConditionalOnMissingBean
    public DubboThreadPoolStatusBinderBean dubboThreadPoolStatusBinderBean(){
        return new DubboThreadPoolStatusBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboThreadPoolStatusBinder dubboThreadPoolStatusBinder(DubboThreadPoolStatusBinderBean dubboThreadPoolStatusBinderBean){
        return new DubboThreadPoolStatusBinder(dubboThreadPoolStatusBinderBean);

    }

    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeAlertCounterBinderBean dubboInvokeAlertCounterBinderBean(){
        return new DubboInvokeAlertCounterBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeAlertCounterBinder dubboLongTimerBinder (DubboInvokeAlertCounterBinderBean dubboInvokeAlertCounterBinderBean){
        return new DubboInvokeAlertCounterBinder(dubboInvokeAlertCounterBinderBean);
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboHealthBinderBean dubboHealthBinderBean(){
        return new DubboHealthBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboHealthBinder dubboHealthBinder(DubboHealthBinderBean dubboHealthBinderBean){
        return new DubboHealthBinder(dubboHealthBinderBean);
    }
}
