/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.liteflow.springboot;

import com.google.common.collect.Lists;
import com.thebeastshop.liteflow.core.FlowExecutor;
import com.thebeastshop.liteflow.spring.ComponentScaner;
import com.thebeastshop.liteflow.springboot.LiteflowProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"liteflow.ruleSource"})
public class LiteflowAutoConfiguration {
    @Bean
    public ComponentScaner componentScaner() {
        return new ComponentScaner();
    }

    @Bean
    public FlowExecutor flowExecutor(LiteflowProperty property) {
        if (StringUtils.isNotBlank((CharSequence)property.getRuleSource())) {
            ArrayList ruleList = Lists.newArrayList((Object[])property.getRuleSource().split(","));
            FlowExecutor flowExecutor = new FlowExecutor();
            flowExecutor.setRulePath((List)ruleList);
            return flowExecutor;
        }
        return null;
    }
}

