/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Decodeable;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceRepository;
import org.apache.dubbo.rpc.protocol.dubbo.CallbackServiceCodec;
import org.apache.dubbo.rpc.protocol.dubbo.DubboCodec;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DecodeableRpcInvocation
extends RpcInvocation
implements Codec,
Decodeable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcInvocation.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Request request;
    private volatile boolean hasDecoded;
    private static final String DUBBOX_VERSION = "2.8.4";

    public DecodeableRpcInvocation(Channel channel, Request request, InputStream is, byte id) {
        Assert.notNull((Object)channel, (String)"channel == null");
        Assert.notNull((Object)request, (String)"request == null");
        Assert.notNull((Object)is, (String)"inputStream == null");
        this.channel = channel;
        this.request = request;
        this.inputStream = is;
        this.serializationType = id;
    }

    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc invocation failed: " + e.getMessage(), e);
                }
                this.request.setBroken(true);
                this.request.setData((Object)e);
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization((URL)channel.getUrl(), (Byte)this.serializationType).deserialize(channel.getUrl(), input);
        String dubboVersion = in.readUTF();
        if (StringUtils.isNotEmpty((String)dubboVersion) && dubboVersion.startsWith(DUBBOX_VERSION)) {
            this.request.setVersion("2.0.0");
            return this.dubboxDecode(in);
        }
        this.request.setVersion(dubboVersion);
        this.setAttachment("dubbo", dubboVersion);
        String path = in.readUTF();
        this.setAttachment("path", path);
        this.setAttachment("version", in.readUTF());
        this.setMethodName(in.readUTF());
        String desc = in.readUTF();
        this.setParameterTypesDesc(desc);
        try {
            Object[] args = DubboCodec.EMPTY_OBJECT_ARRAY;
            Class[] pts = DubboCodec.EMPTY_CLASS_ARRAY;
            if (desc.length() > 0) {
                MethodDescriptor methodDescriptor;
                ServiceRepository repository = ApplicationModel.getServiceRepository();
                ServiceDescriptor serviceDescriptor = repository.lookupService(path);
                if (serviceDescriptor != null && (methodDescriptor = serviceDescriptor.getMethod(this.getMethodName(), desc)) != null) {
                    pts = methodDescriptor.getParameterClasses();
                    this.setReturnTypes(methodDescriptor.getReturnTypes());
                }
                if (pts == DubboCodec.EMPTY_CLASS_ARRAY) {
                    if (!RpcUtils.isGenericCall((String)path, (String)this.getMethodName()) && !RpcUtils.isEcho((String)path, (String)this.getMethodName())) {
                        throw new IllegalArgumentException("Service not found:" + path + ", " + this.getMethodName());
                    }
                    pts = ReflectUtils.desc2classArray((String)desc);
                }
                args = new Object[pts.length];
                for (int i = 0; i < args.length; ++i) {
                    try {
                        args[i] = in.readObject(pts[i]);
                        continue;
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn("Decode argument failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.setParameterTypes(pts);
            Map map = in.readAttachments();
            if (map != null && map.size() > 0) {
                HashMap attachment = this.getObjectAttachments();
                if (attachment == null) {
                    attachment = new HashMap();
                }
                attachment.putAll(map);
                this.setObjectAttachments(attachment);
            }
            for (int i = 0; i < args.length; ++i) {
                args[i] = CallbackServiceCodec.decodeInvocationArgument((Channel)channel, (RpcInvocation)this, (Class[])pts, (int)i, (Object)args[i]);
            }
            this.setArguments(args);
            String targetServiceName = URL.buildKey((String)this.getAttachment("path"), (String)this.getAttachment("group"), (String)this.getAttachment("version"));
            this.setTargetServiceUniqueName(targetServiceName);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(StringUtils.toString((String)"Read invocation data failed.", (Throwable)e));
        }
        finally {
            if (in instanceof Cleanable) {
                ((Cleanable)in).cleanup();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object dubboxDecode(ObjectInput in) throws IOException {
        try {
            this.setAttachment("dubbo", DUBBOX_VERSION);
            this.setAttachment("path", in.readUTF());
            this.setAttachment("version", in.readUTF());
            this.setMethodName(in.readUTF());
            try {
                Object[] args;
                Class[] pts;
                int argNum = in.readInt();
                if (argNum >= 0) {
                    if (argNum == 0) {
                        pts = DubboCodec.EMPTY_CLASS_ARRAY;
                        args = DubboCodec.EMPTY_OBJECT_ARRAY;
                    } else {
                        args = new Object[argNum];
                        pts = new Class[argNum];
                        for (int i = 0; i < args.length; ++i) {
                            try {
                                args[i] = in.readObject();
                                pts[i] = args[i].getClass();
                                continue;
                            }
                            catch (Exception e) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn("Decode argument failed: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                } else {
                    String desc = in.readUTF();
                    if (desc.length() == 0) {
                        pts = DubboCodec.EMPTY_CLASS_ARRAY;
                        args = DubboCodec.EMPTY_OBJECT_ARRAY;
                    } else {
                        pts = ReflectUtils.desc2classArray((String)desc);
                        args = new Object[pts.length];
                        for (int i = 0; i < args.length; ++i) {
                            try {
                                args[i] = in.readObject(pts[i]);
                                continue;
                            }
                            catch (Exception e) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn("Decode argument failed: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                this.setParameterTypes(pts);
                Map map = (Map)in.readObject(Map.class);
                if (map != null && map.size() > 0) {
                    HashMap attachment = this.getAttachments();
                    if (attachment == null) {
                        attachment = new HashMap();
                    }
                    attachment.putAll(map);
                    this.setAttachments(attachment);
                }
                for (int i = 0; i < args.length; ++i) {
                    args[i] = CallbackServiceCodec.decodeInvocationArgument((Channel)this.channel, (RpcInvocation)this, (Class[])pts, (int)i, (Object)args[i]);
                }
                this.setArguments(args);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.toString((String)"Read invocation data failed.", (Throwable)e));
            }
        }
        finally {
            if (in instanceof Cleanable) {
                ((Cleanable)in).cleanup();
            }
        }
        return this;
    }
}

