/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.Cleanable;
import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.utils.Assert;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.Decodeable;
import com.alibaba.dubbo.remoting.exchange.Response;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Map;

public class DecodeableRpcResult
extends RpcResult
implements Codec,
Decodeable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcResult.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Response response;
    private Invocation invocation;
    private volatile boolean hasDecoded;

    public DecodeableRpcResult(Channel channel, Response response, InputStream is, Invocation invocation, byte id) {
        Assert.notNull((Object)channel, (String)"channel == null");
        Assert.notNull((Object)response, (String)"response == null");
        Assert.notNull((Object)is, (String)"inputStream == null");
        this.channel = channel;
        this.response = response;
        this.inputStream = is;
        this.invocation = invocation;
        this.serializationType = id;
    }

    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization((URL)channel.getUrl(), (Byte)this.serializationType).deserialize(channel.getUrl(), input);
        try {
            byte flag = in.readByte();
            switch (flag) {
                case 2: {
                    break;
                }
                case 1: {
                    this.handleValue(in);
                    break;
                }
                case 0: {
                    this.handleException(in);
                    break;
                }
                case 5: {
                    this.handleAttachment(in);
                    break;
                }
                case 4: {
                    this.handleValue(in);
                    this.handleAttachment(in);
                    break;
                }
                case 3: {
                    this.handleException(in);
                    this.handleAttachment(in);
                    break;
                }
                default: {
                    throw new IOException("Unknown result flag, expect '0' '1' '2' '3' '4' '5', but received: " + flag);
                }
            }
            DecodeableRpcResult decodeableRpcResult = this;
            return decodeableRpcResult;
        }
        finally {
            if (in instanceof Cleanable) {
                ((Cleanable)in).cleanup();
            }
        }
    }

    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc result failed: " + e.getMessage(), e);
                }
                this.response.setStatus((byte)90);
                this.response.setErrorMessage(StringUtils.toString((Throwable)e));
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    private void handleValue(ObjectInput in) throws IOException {
        try {
            Type[] returnTypes = RpcUtils.getReturnTypes((Invocation)this.invocation);
            Object value = null;
            value = returnTypes == null || returnTypes.length == 0 ? in.readObject() : (returnTypes.length == 1 ? in.readObject((Class)returnTypes[0]) : in.readObject((Class)returnTypes[0], returnTypes[1]));
            this.setValue(value);
        }
        catch (ClassNotFoundException e) {
            this.rethrow(e);
        }
    }

    private void handleException(ObjectInput in) throws IOException {
        try {
            Object obj = in.readObject();
            if (!(obj instanceof Throwable)) {
                throw new IOException("Response data error, expect Throwable, but get " + obj);
            }
            this.setException((Throwable)obj);
        }
        catch (ClassNotFoundException e) {
            this.rethrow(e);
        }
    }

    private void handleAttachment(ObjectInput in) throws IOException {
        try {
            this.setAttachments((Map)in.readObject(Map.class));
        }
        catch (ClassNotFoundException e) {
            this.rethrow(e);
        }
    }

    private void rethrow(Exception e) throws IOException {
        throw new IOException(StringUtils.toString((String)"Read response data failed.", (Throwable)e));
    }
}

