/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.serialize.Cleanable;
import com.alibaba.dubbo.common.serialize.ObjectInput;
import com.alibaba.dubbo.common.utils.Assert;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.Decodeable;
import com.alibaba.dubbo.remoting.exchange.Request;
import com.alibaba.dubbo.remoting.transport.CodecSupport;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.protocol.dubbo.CallbackServiceCodec;
import com.alibaba.dubbo.rpc.protocol.dubbo.DubboCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class DecodeableRpcInvocation
extends RpcInvocation
implements Codec,
Decodeable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcInvocation.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Request request;
    private volatile boolean hasDecoded;

    public DecodeableRpcInvocation(Channel channel, Request request, InputStream is, byte id) {
        Assert.notNull((Object)channel, (String)"channel == null");
        Assert.notNull((Object)request, (String)"request == null");
        Assert.notNull((Object)is, (String)"inputStream == null");
        this.channel = channel;
        this.request = request;
        this.inputStream = is;
        this.serializationType = id;
    }

    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc invocation failed: " + e.getMessage(), e);
                }
                this.request.setBroken(true);
                this.request.setData((Object)e);
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Channel channel, InputStream input) throws IOException {
        ObjectInput in = CodecSupport.getSerialization((URL)channel.getUrl(), (Byte)this.serializationType).deserialize(channel.getUrl(), input);
        try {
            String dubboVersion = in.readUTF();
            this.setAttachment("dubbo", dubboVersion);
            this.setAttachment("path", in.readUTF());
            this.setAttachment("version", in.readUTF());
            this.setMethodName(in.readUTF());
            try {
                int i;
                Object[] args;
                Class[] pts;
                String desc = in.readUTF();
                String pattern = "-?[0-9]+.?[0-9]*";
                Integer argNum = null;
                if (!Version.isSupportResponseAttachment(dubboVersion) && desc.matches(pattern) && (argNum = Integer.valueOf(Integer.parseInt(desc))) >= 0) {
                    if (argNum == 0) {
                        pts = DubboCodec.EMPTY_CLASS_ARRAY;
                        args = DubboCodec.EMPTY_OBJECT_ARRAY;
                    } else {
                        args = new Object[argNum.intValue()];
                        pts = new Class[argNum.intValue()];
                        for (i = 0; i < args.length; ++i) {
                            try {
                                args[i] = in.readObject();
                                pts[i] = args[i].getClass();
                                continue;
                            }
                            catch (Exception e) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn("Decode argument failed: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                } else {
                    String string = desc = argNum == null ? desc : in.readUTF();
                    if (desc.length() == 0) {
                        pts = DubboCodec.EMPTY_CLASS_ARRAY;
                        args = DubboCodec.EMPTY_OBJECT_ARRAY;
                    } else {
                        pts = ReflectUtils.desc2classArray((String)desc);
                        args = new Object[pts.length];
                        for (i = 0; i < args.length; ++i) {
                            try {
                                args[i] = in.readObject(pts[i]);
                                continue;
                            }
                            catch (Exception e) {
                                if (!log.isWarnEnabled()) continue;
                                log.warn("Decode argument failed: " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                this.setParameterTypes(pts);
                Map map = (Map)in.readObject(Map.class);
                if (map != null && map.size() > 0) {
                    HashMap attachment = this.getAttachments();
                    if (attachment == null) {
                        attachment = new HashMap();
                    }
                    attachment.putAll(map);
                    this.setAttachments(attachment);
                }
                for (int i2 = 0; i2 < args.length; ++i2) {
                    args[i2] = CallbackServiceCodec.decodeInvocationArgument((Channel)channel, (RpcInvocation)this, (Class[])pts, (int)i2, (Object)args[i2]);
                }
                this.setArguments(args);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.toString((String)"Read invocation data failed.", (Throwable)e));
            }
        }
        finally {
            if (in instanceof Cleanable) {
                ((Cleanable)in).cleanup();
            }
        }
        return this;
    }
}

