/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.ClassHelper;
import com.alibaba.dubbo.common.utils.StringUtils;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version {
    private static final Logger logger = LoggerFactory.getLogger(Version.class);
    private static final String VERSION = Version.getVersion(Version.class, "2.0.0");
    private static final boolean INTERNAL = Version.hasResource("com/alibaba/dubbo/registry/internal/RemoteRegistry.class");
    private static final boolean COMPATIBLE = Version.hasResource("com/taobao/remoting/impl/ConnectionRequest.class");
    private static final Map<String, Integer> VERSION2INT;
    public static final int LEGACY_DUBBO_PROTOCOL_VERSION = 10000;
    private static final Pattern PREFIX_DIGITS_PATTERN;
    public static final int LOWEST_VERSION_FOR_RESPONSE_ATTACHMENT = 2000200;
    public static final int HIGHEST_PROTOCOL_VERSION = 2009900;

    private Version() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isInternalVersion() {
        return INTERNAL;
    }

    public static boolean isCompatibleVersion() {
        return COMPATIBLE;
    }

    private static boolean hasResource(String path) {
        try {
            return Version.class.getClassLoader().getResource(path) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            String version = cls.getPackage().getImplementationVersion();
            if (version == null || version.length() == 0) {
                version = cls.getPackage().getSpecificationVersion();
            }
            if (version == null || version.length() == 0) {
                CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    logger.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
                } else {
                    String file = codeSource.getLocation().getFile();
                    if (file != null && file.length() > 0 && file.endsWith(".jar")) {
                        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
                        if (i >= 0) {
                            file = file.substring(i + 1);
                        }
                        if ((i = file.indexOf("-")) >= 0) {
                            file = file.substring(i + 1);
                        }
                        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                            file = file.substring(i + 1);
                        }
                        version = file;
                    }
                }
            }
            return version == null || version.length() == 0 ? defaultVersion : version;
        }
        catch (Throwable e) {
            logger.error("return default version, ignore exception " + e.getMessage(), e);
            return defaultVersion;
        }
    }

    public static void checkDuplicate(Class<?> cls, boolean failOnError) {
        Version.checkDuplicate(cls.getName().replace('.', '/') + ".class", failOnError);
    }

    public static void checkDuplicate(Class<?> cls) {
        Version.checkDuplicate(cls, false);
    }

    public static void checkDuplicate(String path, boolean failOnError) {
        try {
            Enumeration<URL> urls = ClassHelper.getCallerClassLoader(Version.class).getResources(path);
            HashSet<String> files = new HashSet<String>();
            while (urls.hasMoreElements()) {
                String file;
                URL url = urls.nextElement();
                if (url == null || (file = url.getFile()) == null || file.length() <= 0) continue;
                files.add(file);
            }
            if (files.size() > 1) {
                String error = "Duplicate class " + path + " in " + files.size() + " jar " + files;
                if (failOnError) {
                    throw new IllegalStateException(error);
                }
                logger.error(error);
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    public static boolean isSupportResponseAttachment(String version) {
        if (StringUtils.isEmpty((String)version)) {
            return false;
        }
        int iVersion = Version.getIntVersion(version);
        return iVersion >= 2000200 && iVersion <= 2009900;
    }

    public static int getIntVersion(String version) {
        Integer v = VERSION2INT.get(version);
        if (v == null) {
            try {
                v = Version.parseInt(version);
                if (version.split("\\.").length == 3) {
                    v = v * 100;
                }
            }
            catch (Exception e) {
                logger.warn("Please make sure your version value has the right format: \n 1. only contains digital number: 2.0.0; \n 2. with string suffix: 2.6.7-stable. \nIf you are using Dubbo before v2.6.2, the version value is the same with the jar version.");
                v = 10000;
            }
            VERSION2INT.put(version, v);
        }
        return v;
    }

    private static int parseInt(String version) {
        int v = 0;
        String[] vArr = version.split("\\.");
        int len = vArr.length;
        for (int i = 0; i < len; ++i) {
            v = (int)((double)v + (double)Integer.parseInt(Version.getPrefixDigits(vArr[i])) * Math.pow(10.0, (len - i - 1) * 2));
        }
        return v;
    }

    private static String getPrefixDigits(String v) {
        Matcher matcher = PREFIX_DIGITS_PATTERN.matcher(v);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    static {
        Version.checkDuplicate(Version.class);
        VERSION2INT = new HashMap<String, Integer>();
        PREFIX_DIGITS_PATTERN = Pattern.compile("^([0-9]*).*");
    }
}

