/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.enums;

import com.thebeastshop.common.enums.CodeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum TransportCarStatusEnum implements CodeEnum<Integer>
{
    TRUCK_LOADING(1, "\u88c5\u8f66\u4e2d"),
    IN_TRANSIT(2, "\u8fd0\u8f93\u4e2d"),
    UNLOADED(3, "\u5378\u8d27\u5b8c\u6210");

    private Integer code;
    private String name;
    private static final List<TransportCarStatusEnum> ALL;

    private TransportCarStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getName(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).map(TransportCarStatusEnum::getName).findAny().orElse("");
    }

    public static TransportCarStatusEnum getEnum(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).findAny().orElse(null);
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(TransportCarStatusEnum.values()));
    }
}

