/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.vo;

import com.thebeastshop.wms.vo.WhWmsConnectInfoVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhWmsConnectStartResultVO
implements Serializable {
    private List<WhWmsConnectInfoVO> startConnectInfoList = new ArrayList<WhWmsConnectInfoVO>();
    private List<String> failureCommandCodes = new ArrayList<String>();
    private Integer needAmount;
    private Integer planedAmount;
    private Integer startedAmount = 0;
    private Integer skuStatus;
    private Long operaterId;
    private boolean autoDistribute;
    private List<String> shortageSkuCodes;
    private List<String> holdStartCommandCodes;
    private Map<String, Integer> shortageSkuQuantityMap = new HashMap<String, Integer>();

    public boolean isEnough() {
        return this.needAmount <= 0;
    }

    public static WhWmsConnectStartResultVO newInstance() {
        return new WhWmsConnectStartResultVO();
    }

    public Integer getNeedAmount() {
        return this.needAmount;
    }

    public void setNeedAmount(Integer needAmount) {
        this.needAmount = needAmount;
    }

    public WhWmsConnectStartResultVO needAmountAuotDec() {
        this.needAmount = this.needAmount - 1;
        return this;
    }

    public WhWmsConnectStartResultVO startedAmountAuotInc() {
        this.startedAmount = this.startedAmount + 1;
        return this;
    }

    public List<String> getFailureCommandCodes() {
        return this.failureCommandCodes;
    }

    public WhWmsConnectStartResultVO addFailureCommandCode(String commandCode) {
        this.failureCommandCodes.add(commandCode);
        return this;
    }

    public WhWmsConnectStartResultVO addFailureCommandCodes(List<String> commandCodes) {
        if (commandCodes != null) {
            this.failureCommandCodes.addAll(commandCodes);
        }
        return this;
    }

    public Long getOperaterId() {
        return this.operaterId;
    }

    public void setOperaterId(Long operaterId) {
        this.operaterId = operaterId;
    }

    public Integer getSkuStatus() {
        return this.skuStatus;
    }

    public void setSkuStatus(Integer skuStatus) {
        this.skuStatus = skuStatus;
    }

    public List<WhWmsConnectInfoVO> getStartConnectInfoList() {
        return this.startConnectInfoList;
    }

    public WhWmsConnectStartResultVO addStartConnectInfo(WhWmsConnectInfoVO connectInfo) {
        this.startConnectInfoList.add(connectInfo);
        return this;
    }

    public Integer getPlanedAmount() {
        return this.planedAmount;
    }

    public void setPlanedAmount(Integer planedAmount) {
        this.planedAmount = planedAmount;
    }

    public Integer getStartedAmount() {
        return this.startedAmount;
    }

    public void setStartedAmount(Integer startedAmount) {
        this.startedAmount = startedAmount;
    }

    public boolean isAutoDistribute() {
        return this.autoDistribute;
    }

    public void setAutoDistribute(boolean autoDistribute) {
        this.autoDistribute = autoDistribute;
    }

    public List<String> getShortageSkuCodes() {
        return this.shortageSkuCodes;
    }

    public void setShortageSkuCodes(List<String> shortageSkuCodes) {
        this.shortageSkuCodes = shortageSkuCodes;
    }

    public List<String> getHoldStartCommandCodes() {
        return this.holdStartCommandCodes;
    }

    public void setHoldStartCommandCodes(List<String> holdStartCommandCodes) {
        this.holdStartCommandCodes = holdStartCommandCodes;
    }

    public Map<String, Integer> getShortageSkuQuantityMap() {
        return this.shortageSkuQuantityMap;
    }

    public void addShortageSkuQuantity(Map<String, Integer> shortageSkuQuantityMap) {
        try {
            shortageSkuQuantityMap.forEach((sku, quantity) -> {
                if (quantity == null || quantity == 0) {
                    return;
                }
                Integer sum = this.shortageSkuQuantityMap.getOrDefault(sku, 0);
                this.shortageSkuQuantityMap.put((String)sku, sum + quantity);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

