/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.wms.enums;

import com.thebeastshop.common.enums.CodeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum WmsSkuStatusEnum implements CodeEnum<Integer>
{
    Defective(0, "\u6b8b\u6b21"),
    Good(1, "\u826f\u54c1"),
    Sample(2, "\u6837\u54c1"),
    Waste(3, "\u5e9f\u54c1"),
    Moderate_Damaged(4, "\u4e2d\u6b8b"),
    Severe_Damaged(5, "\u91cd\u6b8b"),
    Display(6, "\u9648\u5217\u54c1"),
    Prop(7, "\u9053\u5177"),
    Hold_Pending(8, "\u5f85\u5b9a");

    private final Integer code;
    private final String name;
    public static final List<WmsSkuStatusEnum> ALL;

    private WmsSkuStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static String getNameByCode(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).map(WmsSkuStatusEnum::getName).findAny().orElse("");
    }

    public static WmsSkuStatusEnum getEnumByCode(Integer code) {
        return ALL.stream().filter(item -> item.getCode().equals(code)).findAny().orElse(null);
    }

    public static Integer getCodeByName(String name) {
        return ALL.stream().filter(item -> item.getName().equals(name)).map(WmsSkuStatusEnum::getCode).findAny().orElse(-1);
    }

    public static WmsSkuStatusEnum getEnumByName(String name) {
        return ALL.stream().filter(item -> item.getName().equals(name)).findAny().orElse(null);
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(WmsSkuStatusEnum.values()));
    }
}

