/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.utils;

import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.StrUtil;
import com.thebeastshop.watchman.sdk.anno.WatchmanJob;
import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.core.env.Environment;

public class WatchmanJobUtils {
    private static String env;
    private static final Object ENV_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEnv(Environment environment) {
        if (Objects.isNull(env)) {
            Object object = ENV_LOCK;
            synchronized (object) {
                if (Objects.isNull(env) && !"pro".equalsIgnoreCase(env = environment.getProperty("env", "")) && !"uat".equalsIgnoreCase(env)) {
                    env = null;
                    throw new RuntimeException(StrUtil.format((CharSequence)"[Watchman] \u4e0d\u80fd\u5728 {} \u73af\u5883\u542f\u52a8 Watchman", (Object[])new Object[]{env}));
                }
            }
        }
        return env;
    }

    public static Integer getJobId(Environment environment, WatchmanJob watchmanJob, Method method) {
        String env = WatchmanJobUtils.getEnv(environment);
        boolean isPro = "pro".equalsIgnoreCase(env);
        boolean isUat = "uat".equalsIgnoreCase(env);
        if (!isPro && !isUat) {
            throw new RuntimeException(StrFormatter.format((String)"\u4e0d\u80fd\u5728 {} \u73af\u5883\u4f7f\u7528 Watchman!", (Object[])new Object[]{env}));
        }
        if (isPro && StrUtil.isBlank((CharSequence)watchmanJob.id())) {
            throw new RuntimeException(StrFormatter.format((String)"\u65b9\u6cd5 {} \u7684 @WatchmanJob \u6ce8\u89e3\u7684 Id \u4e3a\u7a7a", (Object[])new Object[]{WatchmanJobUtils.methodName(method)}));
        }
        if (StrUtil.isBlank((CharSequence)watchmanJob.uatId())) {
            return null;
        }
        return isPro ? Integer.parseInt(watchmanJob.id()) : Integer.parseInt(watchmanJob.uatId());
    }

    public static String methodName(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return clazz.getName() + "." + method.getName();
    }

    static {
        ENV_LOCK = new Object();
    }
}

