/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.http.configuration;

import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.backend.okhttp3.OkHttp3Backend;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.json.ForestFastjsonConverter;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.thebeastshop.watchman.sdk.aop.WatchmanAop;
import com.thebeastshop.watchman.sdk.http.client.JobClient;
import com.thebeastshop.watchman.sdk.scanner.WatchmanScanner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(prefix="watchman", name={"enable"}, havingValue="true")
public class WatchmanConfiguration {
    @Bean
    public JobClient jobClient(Environment environment) {
        String address = environment.getProperty("watchman.address");
        ForestConfiguration configuration = ForestConfiguration.configuration((String)"watchman-config");
        configuration.setConnectTimeout(Integer.valueOf(30000));
        configuration.setReadTimeout(Integer.valueOf(30000));
        configuration.setMaxRetryCount(Integer.valueOf(3));
        configuration.setMaxRetryInterval(1000L);
        configuration.setBackend((HttpBackend)new OkHttp3Backend());
        configuration.setVariableValue("address", (Object)address);
        configuration.setJsonConverter((ForestJsonConverter)new ForestFastjsonConverter());
        return (JobClient)configuration.client(JobClient.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public WatchmanAop watchmanAop() {
        return new WatchmanAop();
    }

    @Bean
    @ConditionalOnMissingBean
    public WatchmanScanner watchmanScanner() {
        return new WatchmanScanner();
    }
}

