/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.scanner;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.watchman.sdk.anno.WatchmanJob;
import com.thebeastshop.watchman.sdk.domain.dto.WMRegisterJobDTO;
import com.thebeastshop.watchman.sdk.http.client.JobClient;
import com.thebeastshop.watchman.sdk.utils.WatchmanJobUtils;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.env.Environment;

public class WatchmanScanner
implements BeanPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private JobClient jobClient;
    @Resource
    private Environment environment;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        String app = PropConfig.getAppId();
        Class<?> clazz = bean.getClass();
        Arrays.stream(clazz.getDeclaredMethods()).forEach(method -> {
            WatchmanJob watchmanJob = method.getAnnotation(WatchmanJob.class);
            if (ObjectUtil.isNotNull((Object)watchmanJob)) {
                Integer jobId = WatchmanJobUtils.getJobId(this.environment, watchmanJob, method);
                WMRegisterJobDTO registerJobDTO = new WMRegisterJobDTO();
                registerJobDTO.setJobId(jobId);
                registerJobDTO.setApp(app);
                registerJobDTO.setName(watchmanJob.name());
                registerJobDTO.setMethod(method.getName());
                try {
                    this.jobClient.registerJob(registerJobDTO);
                    this.log.info("[WatchMan]\u6ce8\u518c[{}][{}][{}]", new Object[]{jobId, app, beanName});
                }
                catch (Throwable th) {
                    this.log.error(StrUtil.format((CharSequence)"[Watchman] \u5b9a\u65f6\u4efb\u52a1[jobId = {}, method: {}]\u76d1\u63a7\u6ce8\u518c\u5931\u8d25: {}", (Object[])new Object[]{WatchmanJobUtils.methodName(method), jobId, th.getMessage()}));
                }
            }
        });
        return bean;
    }
}

