/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.http.configuration;

import com.dtflys.forest.Forest;
import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.backend.okhttp3.OkHttp3Backend;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.json.ForestFastjsonConverter;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.springboot.annotation.ForestScan;
import com.thebeastshop.watchman.sdk.aop.WatchmanAop;
import com.thebeastshop.watchman.sdk.scanner.WatchmanScanner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(prefix="watchman", name={"enable"}, havingValue="true")
@ForestScan(value={"com.thebeastshop.watchman.sdk.http.client"})
public class WatchmanConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ForestFastjsonConverter forestFastjsonConverter() {
        return new ForestFastjsonConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ForestConfiguration forestConfiguration(Environment environment, ForestFastjsonConverter forestFastjsonConverter) {
        String address = environment.getProperty("watchman.address");
        ForestConfiguration configuration = Forest.config();
        configuration.setConnectTimeout(Integer.valueOf(30000));
        configuration.setReadTimeout(Integer.valueOf(30000));
        configuration.setMaxRetryCount(Integer.valueOf(3));
        configuration.setMaxRetryInterval(1000L);
        configuration.setBackend((HttpBackend)new OkHttp3Backend());
        configuration.setVariableValue("watchman.address", (Object)address);
        configuration.setJsonConverter((ForestJsonConverter)forestFastjsonConverter);
        return configuration;
    }

    @Bean
    @ConditionalOnMissingBean
    public WatchmanAop watchmanAop() {
        return new WatchmanAop();
    }

    @Bean
    @ConditionalOnMissingBean
    public WatchmanScanner watchmanScanner() {
        return new WatchmanScanner();
    }
}

