/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.scanner;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.watchman.sdk.anno.WatchmanJob;
import com.thebeastshop.watchman.sdk.domain.dto.WMRegisterJobDTO;
import com.thebeastshop.watchman.sdk.http.client.JobClient;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WatchmanScanner
implements BeanPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private JobClient jobClient;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        String app = PropConfig.getAppId();
        Class<?> clazz = bean.getClass();
        Arrays.stream(clazz.getDeclaredMethods()).forEach(method -> {
            WatchmanJob watchmanJob = method.getAnnotation(WatchmanJob.class);
            if (ObjectUtil.isNotNull((Object)watchmanJob)) {
                WMRegisterJobDTO registerJobDTO = new WMRegisterJobDTO();
                registerJobDTO.setJobId(NumberUtil.parseInt((String)watchmanJob.id()));
                registerJobDTO.setApp(app);
                registerJobDTO.setName(watchmanJob.name());
                registerJobDTO.setMethod(method.getName());
                this.jobClient.registerJob(registerJobDTO);
                this.log.info("[WatchMan]\u6ce8\u518c[{}][{}][{}]", new Object[]{watchmanJob.id(), app, beanName});
            }
        });
        return bean;
    }
}

