/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.http.response;

import cn.hutool.core.util.StrUtil;
import com.thebeastshop.watchman.sdk.http.response.ResultCode;
import java.io.Serializable;

public class Res<T>
implements Serializable {
    private final int code;
    private final T data;
    private final String message;

    public Res(int code, T data, String message) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public Res(ResultCode resultCode, T data, String message) {
        this(resultCode.getCode(), data, message);
    }

    public Res(ResultCode resultCode, T data) {
        this(resultCode.getCode(), data, resultCode.getMessage());
    }

    public static <T> Res<T> data(T data) {
        return new Res<T>(ResultCode.SUCCESS, data);
    }

    public static <T> Res<T> data(T data, String message) {
        return new Res<T>(ResultCode.SUCCESS, data, message);
    }

    public static <T> Res<T> data(ResultCode resultCode, T data, String message) {
        return new Res<T>(resultCode, data, message);
    }

    public static <T> Res<T> fail(String msg) {
        return new Res<Object>(ResultCode.FAILURE, null, msg);
    }

    public static <T> Res<T> fail(String msg, Object ... params) {
        return new Res<Object>(ResultCode.FAILURE, null, StrUtil.format((CharSequence)msg, (Object[])params));
    }

    public static <T> Res<T> fail(ResultCode resultCode, String msg) {
        return new Res<Object>(resultCode, null, msg);
    }

    public static <T> Res<T> fail(ResultCode resultCode, String msg, Object ... params) {
        return new Res<Object>(resultCode, null, StrUtil.format((CharSequence)msg, (Object[])params));
    }

    public int getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }
}

