/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.http.configuration;

import com.dtflys.forest.Forest;
import com.dtflys.forest.backend.HttpBackend;
import com.dtflys.forest.backend.okhttp3.OkHttp3Backend;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.converter.json.ForestJacksonConverter;
import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.springboot.annotation.ForestScan;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.thebeastshop.watchman.sdk.aop.WatchmanAop;
import com.thebeastshop.watchman.sdk.scanner.WatchmanScanner;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"watchman.enable"}, havingValue="true")
@ForestScan(value={"com.thebeastshop.watchman.sdk.http.client"})
public class WatchmanConfiguration {
    @Value(value="${watchman.address}")
    private String address;

    @Bean
    public ForestJacksonConverter forestJacksonConverter() {
        ForestJacksonConverter forestJacksonConverter = new ForestJacksonConverter();
        ObjectMapper mapper = forestJacksonConverter.getMapper();
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd hh:mm:ss"));
        mapper.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        return forestJacksonConverter;
    }

    @Bean
    public ForestConfiguration forestConfiguration(ForestJacksonConverter forestJacksonConverter) {
        ForestConfiguration configuration = Forest.config();
        configuration.setConnectTimeout(Integer.valueOf(10000));
        configuration.setReadTimeout(Integer.valueOf(10000));
        configuration.setBackend((HttpBackend)new OkHttp3Backend());
        configuration.setVariableValue("watchman.address", (Object)this.address);
        configuration.setJsonConverter((ForestJsonConverter)forestJacksonConverter);
        return configuration;
    }

    @Bean
    public WatchmanAop watchmanAop() {
        return new WatchmanAop();
    }

    @Bean
    public WatchmanScanner watchmanScanner() {
        return new WatchmanScanner();
    }
}

