/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.watchman.sdk.aop;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.thebeastshop.watchman.sdk.anno.WatchmanJob;
import com.thebeastshop.watchman.sdk.domain.dto.WMJobEndDTO;
import com.thebeastshop.watchman.sdk.domain.dto.WMJobStartDTO;
import com.thebeastshop.watchman.sdk.domain.enums.WMJobEndTypeEnum;
import com.thebeastshop.watchman.sdk.domain.vo.WMJobStartResultVO;
import com.thebeastshop.watchman.sdk.http.client.JobClient;
import com.thebeastshop.watchman.sdk.http.response.Res;
import com.thebeastshop.watchman.sdk.http.response.ResultCode;
import java.lang.reflect.Method;
import java.util.Date;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class WatchmanAop {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private JobClient jobClient;

    @Pointcut(value="@annotation(com.thebeastshop.watchman.sdk.anno.WatchmanJob)")
    public void cut() {
    }

    @Around(value="cut()")
    public Object around1(ProceedingJoinPoint jp) throws Throwable {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        WatchmanJob watchmanJob = method.getAnnotation(WatchmanJob.class);
        WMJobStartDTO jobStartDTO = new WMJobStartDTO();
        jobStartDTO.setJobId(NumberUtil.parseInt((String)watchmanJob.id()));
        jobStartDTO.setStartTime(new Date());
        Res<WMJobStartResultVO> res = this.jobClient.startJob(jobStartDTO);
        try {
            Object object = jp.proceed();
            if (res.getCode() == ResultCode.SUCCESS.getCode()) {
                WMJobEndDTO jobEndDTO = new WMJobEndDTO();
                jobEndDTO.setRecordId(res.getData().getRecordId());
                jobEndDTO.setType(WMJobEndTypeEnum.SUCCESS);
                this.jobClient.endJob(jobEndDTO);
            } else {
                this.log.error(StrUtil.format((CharSequence)"\u8bb0\u5f55watchman\u6210\u529f\u4e8b\u4ef6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object[])new Object[]{res.getMessage()}));
            }
            return object;
        }
        catch (Exception e) {
            WMJobEndDTO jobEndDTO = new WMJobEndDTO();
            jobEndDTO.setRecordId(res.getData().getRecordId());
            jobEndDTO.setType(WMJobEndTypeEnum.FAIL);
            jobEndDTO.setMessage(e.getMessage());
            jobEndDTO.setErrorStack(ExceptionUtil.stacktraceToString((Throwable)e));
            this.jobClient.endJob(jobEndDTO);
            throw e;
        }
    }
}

