package com.thebeastshop.trans.dto.refund;

import com.thebeastshop.trans.enums.TsRefundTypeEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 创建售后订单入参
 *
 * @author Paul-xiong
 */
public class RefundCreateDTO implements Serializable {

    private static final long serialVersionUID = 9200319795848888955L;

    /**
     * 设备ID
     */
    private String deviceId;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * memberId
     */
    private Long memberId;

    /**
     * memberCode
     */
    private String memberCode;

    /**
     * 申请售后的订单行id
     */
    private Long packageSkuId;

    /**
     * 售后原因
     */
    private String refundReason;

    /**
     * 售后原因
     */
    private Integer refundReasonCode;

    /**
     * 售后类型，REFUND 仅退款，RETURN 退货退款，EXCHANGE 换货
     */
    private TsRefundTypeEnum refundType;

    /**
     * 退货数量
     */
    private Integer returnNum;

    /**
     * 退款金额
     */
    private BigDecimal refundAmt;

    /**
     * 售后描述
     */
    private String refundDesc;

    /**
     * 换货商品spvId
     */
    private Long spvId;

    /**
     * 换货商品收货地址
     */
    private RefundAddressDTO address;

    /**
     * 售后描述文件
     */
    private List<RefundMedia> refundMedias;

    public Long getPackageSkuId() {
        return packageSkuId;
    }

    public void setPackageSkuId(Long packageSkuId) {
        this.packageSkuId = packageSkuId;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }


    public Integer getReturnNum() {
        return returnNum;
    }

    public void setReturnNum(Integer returnNum) {
        this.returnNum = returnNum;
    }

    public BigDecimal getRefundAmt() {
        return refundAmt;
    }

    public void setRefundAmt(BigDecimal refundAmt) {
        this.refundAmt = refundAmt;
    }

    public String getRefundDesc() {
        return refundDesc;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public RefundAddressDTO getAddress() {
        return address;
    }

    public void setAddress(RefundAddressDTO address) {
        this.address = address;
    }

    public List<RefundMedia> getRefundMedias() {
        return refundMedias;
    }

    public void setRefundMedias(List<RefundMedia> refundMedias) {
        this.refundMedias = refundMedias;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getMemberCode() {
        return memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Integer getRefundReasonCode() {
        return refundReasonCode;
    }

    public void setRefundReasonCode(Integer refundReasonCode) {
        this.refundReasonCode = refundReasonCode;
    }

    public TsRefundTypeEnum getRefundType() {
        return refundType;
    }

    public void setRefundType(TsRefundTypeEnum refundType) {
        this.refundType = refundType;
    }

    public static class RefundMedia implements Serializable {

        private static final long serialVersionUID = 880487620306284665L;
        /**
         * 媒体文件类型 VIDEO，PIC
         */
        private String mediaType;

        /**
         * 媒体文件地址
         */
        private String url;

        public String getMediaType() {
            return mediaType;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}
