/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.tracker.enums;

import org.apache.commons.lang3.StringUtils;

public enum AIRecScene {
    None(1, "\u65e0", "none"),
    Cart(6, "\u8d2d\u7269\u8f66", "cart"),
    DeliveryInfo(5, "\u7269\u6d41\u8be6\u60c5", "deliveryInfo"),
    My(7, "\u6211\u7684", "my"),
    OrderDetail(3, "\u8ba2\u5355\u8be6\u60c5", "order-detail"),
    Product(2, "\u5546\u54c1\u8be6\u60c5\u9875", "product"),
    ShareOrderDetail(8, "\u6652\u5355\u8be6\u60c5", "shareOrderDetail"),
    Success(4, "\u8d2d\u4e70\u6210\u529f\u9875", "success"),
    PostDetail(9, "\u793e\u533a\u5e16\u5b50\u8be6\u60c5\u9875", "posterDetail");

    private final int id;
    private final String name;
    private final String page;

    private AIRecScene(int id, String name, String page) {
        this.id = id;
        this.name = name;
        this.page = page;
    }

    public int getId() {
        return this.id;
    }

    public static AIRecScene getSceneByPage(String page) {
        if (StringUtils.isBlank((CharSequence)page)) {
            return None;
        }
        String[] strs = page.split("[ ]*/[ ]*");
        page = strs[0];
        for (AIRecScene scene : AIRecScene.values()) {
            if (!scene.page.equalsIgnoreCase(page)) continue;
            return scene;
        }
        return None;
    }
}

