package com.thebeastshop.stock.dto;

import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;

import java.util.Date;

/**
 * Created by admin on 2017/2/3.
 */
public class SStockOccupyDTO extends SStockOperationDTO implements SStockSkuBaseDTO {
    protected String warehouseCode;
    protected String referenceCode;
    protected String skuCode;
    protected Integer quantity;
    protected Date occupyTime;
    protected Date occupyTimeStart;
    protected Date occupyTimeEnd;
    protected String willInTimeStart;
    protected String willInTimeEnd;
    protected Long presaleId;

    protected SStockOccupyTypeEnum preparedOccupyType;
    protected Integer invOccupyType;
    protected String preparedReferenceCode;
    protected String businessCode;
    protected Integer isSplit;
    //是否需要校验库存，默认是
    private boolean needToCheckStock = true;

    public SStockOccupyDTO(){}

	public Integer getIsSplit() {
		return isSplit;
	}

	public void setIsSplit(Integer isSplit) {
		this.isSplit = isSplit;
	}

	public String getWillInTimeStart() {
		return willInTimeStart;
	}

	public void setWillInTimeStart(String willInTimeStart) {
		this.willInTimeStart = willInTimeStart;
	}

	public String getWillInTimeEnd() {
		return willInTimeEnd;
	}

	public void setWillInTimeEnd(String willInTimeEnd) {
		this.willInTimeEnd = willInTimeEnd;
	}

	public Integer getInvOccupyType() {
		return invOccupyType;
	}


	public void setInvOccupyType(Integer invOccupyType) {
		this.invOccupyType = invOccupyType;
	}


	public Date getOccupyTimeStart() {
		return occupyTimeStart;
	}

	public void setOccupyTimeStart(Date occupyTimeStart) {
		this.occupyTimeStart = occupyTimeStart;
	}

	public Date getOccupyTimeEnd() {
		return occupyTimeEnd;
	}

	public void setOccupyTimeEnd(Date occupyTimeEnd) {
		this.occupyTimeEnd = occupyTimeEnd;
	}

	public SStockOccupyDTO(SStockOccupyTypeEnum occupyType) {
        this.occupyType = occupyType;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Date getOccupyTime() {
        return occupyTime;
    }

    public void setOccupyTime(Date occupyTime) {
        this.occupyTime = occupyTime;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public SStockOccupyTypeEnum getPreparedOccupyType() {
        return preparedOccupyType;
    }

    public void setPreparedOccupyType(SStockOccupyTypeEnum preparedOccupyType) {
        this.preparedOccupyType = preparedOccupyType;
    }

    public String getPreparedReferenceCode() {
        if (preparedReferenceCode != null)
            return preparedReferenceCode;
        return businessCode + "_" + skuCode;
    }

    public void setPreparedReferenceCode(String preparedReferenceCode) {
        this.preparedReferenceCode = preparedReferenceCode;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

  public boolean isNeedToCheckStock() {
    return needToCheckStock;
  }

  public void setNeedToCheckStock(boolean needToCheckStock) {
    this.needToCheckStock = needToCheckStock;
  }
}
