package com.thebeastshop.stock.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.dto.SAlwaysCanUse;

import java.util.Map;

/**
 * SPV 库存明细
 */
public class SSpvStockDetailVO extends BaseDO implements SAlwaysCanUse<SSpvStockDetailVO> {

    /**
     * 是否来单
     */
    protected Boolean jit;

    /**
     * 是否组合
     */
    protected Boolean combined;

    /**
     * 是否预告
     */
    protected Boolean announce;

    /**
     * 是否定金预售
     */
    protected Boolean deposit;


    /**
     * SPV ID
     */
    private Long spvId;

    /**
     * SPU 编号
     */
    private String prodCode;

    /**
     * 库存渠道
     */
    private SStockChannelVO channel;

    /**
     * SPV 库存总数
     */
    private Integer totalQuantity;

    /**
     * SPV 库存可用数量
     */
    private Integer canUseQuantity;

    /**
     * SPV 真实可用数量
     */
    private Integer realCanUseQuantity;

    /**
     * 该 SPV 下所有 SKU 库存信息
     * <ul>
     *     <li>Key: Sku编号</li>
     *     <li>Value: Sku库存 {@link SStockOfSku} 对象</li>
     * </ul>
     */
    private Map<String, SStockOfSku> skuStocks;

    private Boolean canUse;


    @Override
    public Boolean getJit() {
        return jit;
    }

    public SSpvStockDetailVO setJit(Boolean jit) {
        this.jit = jit;
        return this;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    @Override
    public Boolean getAnnounce() {
        return announce;
    }

    public SSpvStockDetailVO setAnnounce(Boolean announce) {
        this.announce = announce;
        return this;
    }

    @Override
    public Boolean getDeposit() {
        return deposit;
    }

    public SSpvStockDetailVO setDeposit(Boolean deposit) {
        this.deposit = deposit;
        return this;
    }

    public Boolean getCanUse() {
        return canUse;
    }

    public void setCanUse(Boolean canUse) {
        this.canUse = canUse;
    }

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public String getProdCode() {
        return prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public SStockChannelVO getChannel() {
        return channel;
    }

    public void setChannel(SStockChannelVO channel) {
        this.channel = channel;
    }

    public Integer getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public Integer getCanUseQuantity() {
        return canUseQuantity;
    }

    public void setCanUseQuantity(Integer canUseQuantity) {
        this.canUseQuantity = canUseQuantity;
    }

    public Integer getRealCanUseQuantity() {
        return realCanUseQuantity;
    }

    public void setRealCanUseQuantity(Integer realCanUseQuantity) {
        this.realCanUseQuantity = realCanUseQuantity;
    }

    public Map<String, SStockOfSku> getSkuStocks() {
        return skuStocks;
    }

    public void setSkuStocks(Map<String, SStockOfSku> skuStocks) {
        this.skuStocks = skuStocks;
    }

}
