package com.thebeastshop.stock.vo;


import com.thebeastshop.stock.enums.SSkuStockTypeEnum;

import java.util.List;

/**
 * SKU库存信息
 * @author gongjun
 * @date 2017-02-03
 */
public class SSkuStockVO extends SStockOfSku<SSkuStockVO> {
    private static final long serialVersionUID = 1L;
    // 实际库存
    private Integer realQuantity;
    // 占用库存
    private Integer occupyQuantity;
    // 可用库存
    private Integer canUseQuantity;
    // 预备库存列表
    private List<SPreparedStockVO> preparedList;

    private Integer realCanUseQuantity;

    public SSkuStockVO() {
        super(SSkuStockTypeEnum.DEFAULT);
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Integer getRealQuantity() {
        return realQuantity;
    }

    public void setRealQuantity(Integer realQuantity) {
        this.realQuantity = realQuantity;
    }

    public Integer getOccupyQuantity() {
        return occupyQuantity;
    }

    public void setOccupyQuantity(Integer occupyQuantity) {
        this.occupyQuantity = occupyQuantity;
    }

    @Override
    public Integer getTotalQuantity() {
        return realQuantity;
    }

    @Override
    public Integer getCanUseQuantity() {
        return canUseQuantity;
    }

    public void setCanUseQuantity(Integer canUseQuantity) {
        this.canUseQuantity = canUseQuantity;
    }

    public List<SPreparedStockVO> getPreparedList() {
        return preparedList;
    }

    public void setPreparedList(List<SPreparedStockVO> preparedList) {
        this.preparedList = preparedList;
    }

    @Override
    public Integer getRealCanUseQuantity() {
        return realCanUseQuantity;
    }

    public void setRealCanUseQuantity(Integer realCanUseQuantity) {
        this.realCanUseQuantity = realCanUseQuantity;
    }
}
