package com.thebeastshop.stock.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockPrepareDTO;
import com.thebeastshop.stock.dto.SStockPrepareQuantityChangeDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.vo.SOccupyAfterReleaseResultVO;
import com.thebeastshop.stock.vo.SOccupyResultVO;
import com.thebeastshop.stock.vo.SReleaseResultVO;
import com.thebeastshop.stock.vo.SStockRecordVO;

import java.util.List;

public interface TCCStockService {

    /**
	 * 记录库存
	 * @param record
	 * @return
     */
    ServiceResp<SStockRecordVO> record(SStockRecordVO record);

    ServiceResp<List<SStockRecordVO>> batchRecord(List<SStockRecordVO> recordList);

	/**
	 * 预备库存
	 * @param prepareDTO
	 * @return
     */
	ServiceResp<SOccupyResultVO> prepare(SStockPrepareDTO prepareDTO);

	/**
	 * 增加预备库存数量
	 * @param quantityChangeDTO
	 * @return
	 */
	ServiceResp<SStockPrepareQuantityChangeDTO> incrementPreparedQuantity(SStockPrepareQuantityChangeDTO quantityChangeDTO);

	/**
	 * 减少预备库存数量
	 * @param quantityChangeDTO
	 * @return
	 */
	ServiceResp<SStockPrepareQuantityChangeDTO> decrementPreparedQuantity(SStockPrepareQuantityChangeDTO quantityChangeDTO);

	/**
	 * 占用库存
	 * @param occupyDTO
	 * @return
     */
	ServiceResp<SOccupyResultVO> occupy(SStockOccupyDTO occupyDTO);

	/**
	 * 批量占用库存
	 * @param occupyDTOList
	 * @return
     */
	ServiceResp<List<SOccupyResultVO>> occupy(List<SStockOccupyDTO> occupyDTOList);

	/**
	 * 释放后占用
	 * @param occupyDTOList
	 * @param releaseOccupationDTOList
     * @return
     */
	ServiceResp<SOccupyAfterReleaseResultVO> occupyAfterRelease(
			List<SStockOccupyDTO> occupyDTOList,
			List<SStockReleaseDTO> releaseOccupationDTOList);

	/**
	 * 释放后占用 (不影响缓存)
	 * @param occupyDTOList
	 * @param releaseOccupationDTOList
	 * @return
	 */
	ServiceResp<SOccupyAfterReleaseResultVO> occupyAfterReleaseWithoutCache(
			List<SStockOccupyDTO> occupyDTOList,
			List<SStockReleaseDTO> releaseOccupationDTOList);

	/**
	 * 释放占用库存
	 * @param releaseOccupationDTO
	 * @return
     */
	ServiceResp<SReleaseResultVO> release(SStockReleaseDTO releaseOccupationDTO);

	/**
	 * 批量释放占用库存
	 * @param releaseOccupationDTOList
	 * @return
     */
	ServiceResp<List<SReleaseResultVO>> release(List<SStockReleaseDTO> releaseOccupationDTOList);

}
