package com.thebeastshop.stock.dto;

/**
 * 普通线上渠道下的 SPV 库存明细查询对象接口
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @see SSpvStockDetailQueryDTO
 * @see SSpvCombinedStockDetailQueryDTO
 * @since 1.7.6
 */
public interface SSpvStockDetailQuery extends SAlwaysCanUse {

    /**
     * 获取 SPV ID
     *
     * @return SPV ID
     */
    Long getSpvId();

    /**
     * 获取 SPV 的商品编号
     *
     * @return 商品编号
     */
    String getProdCode();

    /**
     * 是否组合
     *
     * @return {@code true}: 是组合, 否则不是组合
     */
    Boolean getCombined();




}
