package com.thebeastshop.stock.enums;

public enum SStockInOutTypeEnum {
	IN_TYPE_ALLOT(10,"调拨入库"),
    IN_TYPE_PURCHASE(11,"采购入库"),
	IN_TYPE_RETURN(12,"退货入库"),
	IN_TYPE_SAMPLE(13,"样品入库"),
	IN_TYPE_OVERAGE(14,"盘盈入库"),
	IN_TYPE_PRODUCT(15,"生产加工入库"),
	IN_TYPE_MOVE(19,"库间移入"),
	OUT_TYPE_ALLOT(20,"调拨出库"),
	OUT_TYPE_PURCHASE(21,"采购出库"),
	OUT_TYPE_SALES(22,"销售出库"),
	OUT_TYPE_GIFT(23,"礼品出库"),
	OUT_TYPE_SAMPLE(24,"样品出库"),
	OUT_TYPE_CHANGE(25,"换货出库"),
	OUT_TYPE_SHORTAGE(26,"盘盈出库"),
	OUT_TYPE_PRODUCT(27,"生产加工出库"),
	OUT_TYPE_PURCHASE_RETURN(28, "采退出库"),
	OUT_TYPE_MOVE(29,"库间移出"),
	OUT_TYPE_ALLOT_OCCUPY(30,"调拨库存占用"),
	OUT_TYPE_GRADE_ADJUST(32,"品级调整出库"),
	IN_TYPE_GRADE_ADJUST(8,"品级调整入库"),
	IN_TYPE_CROSSGOODS(16, "串货入库"),
	OUT_TYPE_CROSSGOODS(33, "串货出库"),
	;
	private Integer code;

	private String name;

	SStockInOutTypeEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}
	
	public String getName(){
		return name;
	}

	public static SStockInOutTypeEnum getEnumByCode(Integer code) {
		for (SStockInOutTypeEnum e : SStockInOutTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}
	
	@Override
	public String toString() {
		return this.getCode().toString();
	}
}
