/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.stock.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.thebeastshop.common.BaseDO;

/**
 * @author Royan
 * @version $Id: OpPresaleSaleInvVO.java, v 0.1 2015-07-08 下午10:27
 */
public class SPresaleSaleInvVO extends BaseDO {

	private static final long serialVersionUID = 1L;
	
	private String skuCode;
    private String warehouseCode;
    private int totalQuantity = 0;
    private int saledQuantity = 0;
    private int canUseInv = 0;
    private String nameCn;
    private String warehouseName;
    private String skuTypeStr;
    private Long presaleId;
    /**
     * 预售开始日期
     */
    private Date openTime;
    /**
     * 预售结束日期
     */
    private Date closeTime;
    /**
     * 预计发货日期
     */
    private Date planedDeliveryDate;
    
    private Integer quantity;
    
    private BigDecimal price;
    private BigDecimal discountPrice;
    
    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public int getTotalQuantity() {
        return totalQuantity;
    }

    public void setTotalQuantity(int totalQuantity) {
        this.totalQuantity = totalQuantity;
    }
	
	public Long getPresaleId() {
		return presaleId;
	}
	
	public void setPresaleId(Long presaleId) {
		this.presaleId = presaleId;
	}
	
	public int getSaledQuantity() {
        return saledQuantity;
    }

    public void setSaledQuantity(int saledQuantity) {
        this.saledQuantity = saledQuantity;
    }

	public Date getOpenTime() {
		return openTime;
	}

	public void setOpenTime(Date openTime) {
		this.openTime = openTime;
	}

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getSkuTypeStr() {
        return skuTypeStr;
    }

    public void setSkuTypeStr(String skuTypeStr) {
        this.skuTypeStr = skuTypeStr;
    }

    public Date getCloseTime() {
		return closeTime;
	}

	public void setCloseTime(Date closeTime) {
		this.closeTime = closeTime;
	}

	public Date getPlanedDeliveryDate() {
		return planedDeliveryDate;
	}

	public void setPlanedDeliveryDate(Date planedDeliveryDate) {
		this.planedDeliveryDate = planedDeliveryDate;
	}

	public Integer getQuantity() {
		return quantity;
	}

	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}

	public BigDecimal getPrice() {
		return price;
	}

	public void setPrice(BigDecimal price) {
		this.price = price;
	}

	public BigDecimal getDiscountPrice() {
		return discountPrice;
	}

	public void setDiscountPrice(BigDecimal discountPrice) {
		this.discountPrice = discountPrice;
	}

	public int getAvailQuantity() {
		return totalQuantity - saledQuantity;
	}

	public int getCanUseInv() {
		return canUseInv;
	}

	public void setCanUseInv(int canUseInv) {
		this.canUseInv = canUseInv;
	}
}
