package com.thebeastshop.stock.enums;

import com.thebeastshop.common.exception.BaseErrorCode;

public enum SStockErrorCodeEnum implements BaseErrorCode {
	CONVERT_ERROR("0008", "类型转换错误"),
	ROLLBACK_FAILED("0010", "回滚失败"),
	PHYSICAL_WAREHOUSE_HAS_SAME_TYPE_WAREHOUSE("0100","同物理仓只能有一个当前类型的逻辑仓"),
	RECORD_FAILED("0011","记录库存异常"),
	STOCK_NOT_ENOUGH("0101","库存不足"),
	OCCUPY_FAILED_INSERT("0103","占用库存失败,数据库插入异常"),
	OCCUPY_FAILED("0104","占用库存失败"),
	UPDATE_OCCUPY_FAILED("0105","占用更新失败"),
	WAREHOUSE_NOT_FIND("0107","找不到仓库"),
	WRONG_WAREHOUSE_TYPE("0108","仓库类型不符"),
	ALLOT_NOT_FOUND("0109","调拨不存在"),
	UPDATE_ALLOT_FAILED("0110","调拨更新失败"),
	RELEASE_OCCUPATION_FAILED("0114","释放占用库存失败"),
	INVALID_CONNECT_START("0201","不符合波次启动规则"),
	TASK_ASSIGNED("0117","任务已领取"),
	PRESALE_CREATE_FAILED("0301","预售创建失败"),
	PRESALE_QUANTITY_CONFIG_ERROR("0302","预售数量不能小于SKU出售数量"),
	PRESALE_UPDATE_FAILED("0303","预售更新失败"),
	PRESALE_DELETE_FAILED("0304","预售删除失败"),
	PRESALE_BATCHCREATE_FAILED("0305","预售批量创建失败"),
	BEAST_EXCHANGE_STOCK_QUERY_FAILED("0401","兑换服务库存查询失败"),

	GROUPBUY_START_STOCK_NOT_ENOUGH("0501","剩余库存总量小于拼团所需总数量"),
	GROUPBUY_START_STOCK_NOT_SUPPORT("0502","剩余库存不支持此团所需的份数"),
	GROUPBUY_CANNOT_GET_STOCK_INFO("0503","无法获取团购库存"),
	GROUPBUY_OWNER_OCCUPY_ERROR("0504","团长占用出现异常"),
	GROUPBUY_RELATED_KEY_NOT_EXISTS("0505","相关KEY不存在"),
	GROUPBUY_CANNOT_GET_SKUCODES_BY_GRPID("0506","无法通过拼团ID获得SKU列表"),
	GROUPBUY_PARTER_STOCK_NOT_ENOUGH("0507","参团占用SKU库存不足"),
	GROUPBUY_PARTER_FULL("0508","拼团人数已满"),
	GROUPBUY_PARTER_OCCUPY_ERROR("0509","参团占用出现异常"),
	GROUPBUY_PARTER_GROUP_NOT_EXIST("0510","参团时还没开团或者不存在"),
	GROUPBUY_CANNOT_GET_LOCK("0511","建团或者开团时无法获取锁"),
	GROUPBUY_CHECK_SKU_RELATED_ERROR("0512","检查sku关联拼团占用错误"),
	;

	private String errorCode;
	private String message;

	SStockErrorCodeEnum(String errorCode, String message) {
		this.errorCode = errorCode;
		this.message = message;
	}

	public static SCancelEnum getEnumByCode(String code) {
		for (SCancelEnum e : SCancelEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return this.getErrorCode().toString();
	}

	@Override
	public String getErrorCode() {
		return getPrefix() + errorCode;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public String getPrefix() {
		return "SS";
	}
}
