package com.thebeastshop.stock.enums;

import com.thebeastshop.common.exception.BaseErrorCode;

public enum WhCommandErrorCodeEnum implements BaseErrorCode {
	COMMAND_NOT_EXIST("0001", "command不存在"),
	COMMAND_SKU_NOT_EXIST("0002", "command_SKU不存在"),
	COMMAND_SKU_QUANTITY_NULLORZERO("0003", "command_SKU数量异常"),
	;

	private String errorCode;
	private String message;

	WhCommandErrorCodeEnum(String errorCode, String message) {
		this.errorCode = errorCode;
		this.message = message;
	}

	public static SCancelEnum getEnumByCode(String code) {
		for (SCancelEnum e : SCancelEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return this.getErrorCode().toString();
	}

	@Override
	public String getErrorCode() {
		return getPrefix() + errorCode;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public String getPrefix() {
		return "WH";
	}
}
