package com.thebeastshop.stock.service;

import com.thebeastshop.litx.annotations.Compensable;
import com.thebeastshop.stock.dto.SStockOccupyDTO;
import com.thebeastshop.stock.dto.SStockReleaseDTO;
import com.thebeastshop.stock.vo.SWhCommandSkuVO;
import com.thebeastshop.stock.vo.SWhCommandVO;
import com.thebeastshop.stock.vo.SWhStockProcessResultVO;

import java.util.List;

/**
 * Created by libin.kang on 2018/10/17.
 */
public interface SWhCommandService {

    @Compensable
    SWhCommandVO createWhCommand(SWhCommandVO sWhCommandVO);

    void rollbackCreateWhCommand(SWhCommandVO sWhCommandVO);

    @Compensable
    List<SWhCommandVO> recordWhCommand(List<SWhCommandVO> sWhCommandList);

    void rollbackRecordWhCommand(List<SWhCommandVO> sWhCommandList);

    @Compensable
    SWhStockProcessResultVO processStockReleaseOccupy(List<SStockReleaseDTO> releaseOccupationDTOList,List<SWhCommandVO> recordCommandList, List<SStockOccupyDTO> occupyDTOList);

    void rollbackProcessStockReleaseOccupy(SWhStockProcessResultVO sWhStockProcessResultVO);

    @Compensable
    SWhCommandVO createWhCommandWithOccupy(SWhCommandVO sWhCommandVO);

    void rollbackCreateWhCommandWithOccupy(SWhCommandVO sWhCommandVO);

    @Compensable
    SWhCommandVO finishWhCommand(SWhCommandVO sWhCommandVO);

    void rollbackFinishWhCommand(SWhCommandVO sWhCommandVO);

    @Compensable
    SWhCommandVO processCommandFinish(SWhCommandVO sWhCommandVO);

    void rollbackProcessCommandFinish(SWhCommandVO sWhCommandVO);

    @Compensable
    SWhCommandVO processAllotPackageInBound(SWhCommandVO sWhCommandVO);

    void rollbackProcessAllotPackageInBound(SWhCommandVO sWhCommandVO);

    @Compensable
    SWhCommandVO updateWhCommandByKey(SWhCommandVO sWhCommandVO);

    void rollbackUpdateWhCommandByKey(SWhCommandVO sWhCommandVO);

    @Compensable
    SWhCommandSkuVO updateWhCommandSkuByKey(SWhCommandSkuVO sWhCommandSkuVO);

    void rollbackUpdateWhCommandSkuByKey(SWhCommandSkuVO sWhCommandSkuVO);

    @Compensable
    SWhCommandVO insertCommand(SWhCommandVO sWhCommandVO);

    void rollbackInsertCommand(SWhCommandVO sWhCommandVO);

    @Compensable
    SWhCommandSkuVO insertCommandSku(SWhCommandSkuVO sWhCommandSkuVO);

    void rollbackInsertCommandSku(SWhCommandSkuVO sWhCommandSkuVO);



}
