package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.vo.SStockChannelVO;

/**
 * SKU 组合项
 * <p>
 * 库存明细查询信息中组合商品所包含的 SKU 组合项对象
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @since 1.7.6
 */
public class SCombinationDTO extends BaseDO implements SAlwaysCanUse {

    /**
     * 是否来单
     */
    protected Boolean jit;

    /**
     * 是否预告
     */
    protected Boolean announce;

    /**
     * 是否定金预售
     */
    protected Boolean deposit;

    /**
     * 组合项 SKU 所再的库存渠道
     */
    private SStockChannelVO channel;

    /**
     * 组合商品绑定的 SKU 数量
     */
    private Integer quantity;

    /**
     * 组合商品绑定的 SKU 编号
     */
    private String skuCode;

    public Integer getQuantity() {
        return quantity;
    }

    @Override
    public Boolean getJit() {
        return jit;
    }

    public SCombinationDTO setJit(Boolean jit) {
        this.jit = jit;
        return this;
    }

    @Override
    public Boolean getAnnounce() {
        return announce;
    }

    public SCombinationDTO setAnnounce(Boolean announce) {
        this.announce = announce;
        return this;
    }

    @Override
    public Boolean getDeposit() {
        return deposit;
    }

    public SCombinationDTO setDeposit(Boolean deposit) {
        this.deposit = deposit;
        return this;
    }

    public SStockChannelVO getChannel() {
        return channel;
    }

    public SCombinationDTO setChannel(SStockChannelVO channel) {
        this.channel = channel;
        return this;
    }

    public SCombinationDTO setQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public SCombinationDTO setSkuCode(String skuCode) {
        this.skuCode = skuCode;
        return this;
    }
}
