package com.thebeastshop.stock.dto;

/**
 * 抽象 SPV 库存明细查询基类
 *
 * @author Jun.Gong [jun.gong@thebeastshop.com]
 * @param <SELF> 对象自身
 * @see com.thebeastshop.stock.dto.SAbstractStockQueryDTO
 * @since 1.7.6
 */
public abstract class SAbstractSpvStockDetailQueryDTO<SELF extends SAbstractSpvStockDetailQueryDTO<SELF>> extends SAbstractStockQueryDTO<SELF> {

    /**
     * 商品编号
     */
    private String prodCode;

    /**
     * SPV ID
     */
    protected Long spvId;

    public String getProdCode() {
        return prodCode;
    }

    public SELF setProdCode(String prodCode) {
        this.prodCode = prodCode;
        return (SELF) this;
    }

    public Long getSpvId() {
        return spvId;
    }

    public SELF setSpvId(Long spvId) {
        this.spvId = spvId;
        return (SELF) this;
    }

}
