package com.thebeastshop.stock.service;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.stock.dto.SPresaleInstallQueryDTO;
import com.thebeastshop.stock.dto.SStockPresaleQueryDTO;
import com.thebeastshop.stock.vo.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2017-02-09
 */
public interface SPresaleService {
	
	void refreshPresaleCache(SPresaleVO presaleVO,boolean refreshSaledFlag);
	
	void refreshPresaleCache(List<Long> presaleIdList);

    ServiceResp create(SPresaleVO presale);

    ServiceResp create(List<SPresaleVO> presaleList);

    ServiceResp update(SPresaleVO presale);

    ServiceResp update(List<SPresaleVO> presaleList);

    ServiceResp deleteById(Long id);

    List<SPresaleVO> findByCond(SStockPresaleQueryDTO cond);

    List<SPresaleVO> findByCondOrderByCreateTimeDesc(SStockPresaleQueryDTO cond);

    List<SPresaleVO> findByCondForCorn(SStockPresaleQueryDTO cond);

    List<SPresaleVO> findByCond(List<String> skuCodeList, Date planedDeliveryDate);

    SPresaleVO findById(Long id);

    List<SPresaleVO> findPreSalesByChannelTypesAndIds(List<Integer> channelTypes,List<Long> id);

    SPresaleSaleInvVO findCanUseQttBySkuCode(String skuCode,Integer channelType);

    Map<String,SPresaleSaleInvVO> findCanUseQttBySkuCodes(List<String> skuCodeList, Integer channelType);

    SStockOccupyRecordVO findPresaleOccupyByReferenceCode(String referenceCode);

    Integer calPresaleAvailableQuantity(Long presaleId);

    Integer calPreOccupyQuantity(Long presaleId);

    Integer calPreOccupyQuantityByDB(Long presaleId);

    Integer calPreSaledQuantity(Long presaleId);

    Integer calPreSaledQuantityByDB(Long presaleId);

    Integer calNoPaymantQuantity(Long presaleId);

    Integer calPreConvertedQuantity(Long presaleId);

    Integer calTotalPreSaledQuantity(String skuCode);

    Integer calTotalPreConvertedQuantity(String skuCode, Integer channelType);

    SPresaleVO findAvaliableBySkuCode(String skuCode, Boolean isOffline);
    
    SPresaleVO findAvaliableBySkuCode(String skuCode,Integer channelType);

    Map<String,SPresaleVO> findAvaliableBySkuCodes(List<String> skuCodeList, Boolean isOffline);

    Map<Long,Date> findPlanedDeliveryDateBySpvIds(final List<Long> spvIds);
    
    Map<String, Date> findPlanedDeliveryDateBySkuCodes(List<String> skuCodeList,Integer channelType);

    List<SPresaleSaleInvVO> calAvaliableQuantityAndSaledQuantity();

    List<Long> closeOutDatePresale();

    Integer calDeliveriedQuantity(Long presaleId);

    List<Long> findWaitConvertPresaleId();

    List<Long> findWaitAllotPresaleId();

    List<SPresaleEmailVO> findPreSaleInfo();

    List<SPresaleEmailVO> findPreSaleInfoLine();//线下渠道短信发送

    List<SPresaleEmailVO> findPreSaleInfoOnLine();//线上渠道短信发送

    List<SPresaleVO> findToConvergence();

    List<SPresaleInstallVO> findOpPresaleInstallByParams(SPresaleInstallQueryDTO cond);

    Integer createOrUpdatePreInstall(SPresaleInstallVO install);

    List<SPresaleVO> findWaitAuditPreSales();

    int updateAllotedQuantity(long presaleId, int currentNumber);
    
    void automaticConvergence(Long presaleId);

    /**
     * 找到sku的未分货完成的预售
     * @param skuCodeList
     * @return
     */
    List<SPresaleVO> findUnfinishedAllotPreSale(List<String> skuCodeList);

	/**
     * 查询SKU 预售拼团占用
     * @param skuCodes
     * @return
     */
    Map<String, Integer> getSkuPresaleGroupBuyOccupation(List<String> skuCodes);

    Map<String, Integer> mapUnAllotedCntBySkuCode(List<String> skuCodes);
}