package com.thebeastshop.stock.exception;

import com.thebeastshop.common.exception.BaseServiceException;
import com.thebeastshop.common.exception.CommonErrorCode;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 库存KEY不存在异常
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-01 14:32
 */
public class SStockKeyNotExistException extends BaseServiceException {

    public final static String ERROR_DATA_KEY = "keyErrorList";

    private List<SKeyErrorItem> keyErrorList;

    public SStockKeyNotExistException(List<SKeyErrorItem> keyErrorList, String msg) {
        super(CommonErrorCode.STATUS_NOT_EXPECTED, msg);
        this.keyErrorList = keyErrorList;
    }

    public List<SKeyErrorItem> getKeyErrorList() {
        return keyErrorList;
    }

    public void setKeyErrorList(List<SKeyErrorItem> keyErrorList) {
        this.keyErrorList = keyErrorList;
    }

    public List<String> getKeyList() {
        List<String> keyList = new LinkedList<>();
        for (SKeyErrorItem item : keyErrorList) {
            keyList.add(item.getKey());
        }
        return keyList;
    }

    @Override
    public Map<String, Object> getErrorData() {
        Map<String, Object> errorData = new HashMap<>();
        errorData.put(ERROR_DATA_KEY, keyErrorList);
        return errorData;
    }

}
