package com.thebeastshop.stock.vo;

import com.thebeastshop.stock.dto.SStockReleaseDTO;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-05 14:50
 */
public class SReleaseResultVO extends SStockReleaseDTO {

    private static final long serialVersionUID = 1L;

	  private Long id;

    private String skuCode;

    private String warehouseCode;

    private Integer numberOfReleased;

    private Long presaleId;

    private String preparedBusinessCode;

    private Integer preparedOccupyType;

    private Long releasedPreparedOccupationId;

    private Integer releasedPrepared = 0;

    private Integer quantity;

    private Integer cityId;

    private Byte flowerProductionType;

    // 是否以前已经被释放了，不需要再次释放
    private Boolean alreadyReleasedBefore = false;

    private List<SReleaseResultVO> jitReleaseResultList;

    public void initWithRelease(SStockReleaseDTO releaseDTO) {
        this.operationType = releaseDTO.getOperationType();
        this.occupyType = releaseDTO.getOccupyType();
        this.referenceCode = releaseDTO.getReferenceCode();
        this.packageCode = releaseDTO.getPackageCode();
        this.preparedSkuCode = releaseDTO.getPreparedSkuCode();
        this.preparedReleaseQuantity = releaseDTO.getPreparedReleaseQuantity();
        this.businessCode = releaseDTO.getBusinessCode();
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public List<SReleaseResultVO> getJitReleaseResultList() {
        return jitReleaseResultList;
    }

    public void setJitReleaseResultList(List<SReleaseResultVO> jitReleaseResultList) {
        this.jitReleaseResultList = jitReleaseResultList;
    }

    public Integer getNumberOfReleased() {
        return numberOfReleased;
    }

    public void setNumberOfReleased(Integer numberOfRleased) {
        this.numberOfReleased = numberOfRleased;
    }

    public Long getPresaleId() {
        return presaleId;
    }

    public void setPresaleId(Long presaleId) {
        this.presaleId = presaleId;
    }

    public String getPreparedBusinessCode() {
        return preparedBusinessCode;
    }

    public void setPreparedBusinessCode(String preparedBusinessCode) {
        this.preparedBusinessCode = preparedBusinessCode;
    }

    public Integer getPreparedOccupyType() {
        return preparedOccupyType;
    }

    public void setPreparedOccupyType(Integer preparedOccupyType) {
        this.preparedOccupyType = preparedOccupyType;
    }

    public Long getReleasedPreparedOccupationId() {
        return releasedPreparedOccupationId;
    }

    public void setReleasedPreparedOccupationId(Long releasedPreparedOccupationId) {
        this.releasedPreparedOccupationId = releasedPreparedOccupationId;
    }

    public Boolean getAlreadyReleasedBefore() {
        return alreadyReleasedBefore;
    }

    public void setAlreadyReleasedBefore(Boolean alreadyReleasedBefore) {
        this.alreadyReleasedBefore = alreadyReleasedBefore;
    }

    public Integer getReleasedPrepared() {
        return releasedPrepared;
    }

    public void setReleasedPrepared(Integer releasedPrepared) {
        this.releasedPrepared = releasedPrepared;
    }

    public Integer getCityId() {
        return cityId;
    }

    public void setCityId(Integer cityId) {
        this.cityId = cityId;
    }

    public Byte getFlowerProductionType() {
        return flowerProductionType;
    }

    public void setFlowerProductionType(Byte flowerProductionType) {
        this.flowerProductionType = flowerProductionType;
    }
}
