/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.sensors.core;

import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.sensors.enums.TrackTypeEnum;
import com.thebeastshop.sensors.vo.CommonVO;
import com.thebeastshop.sensors.vo.TrackDataVO;
import com.thebeastshop.sensors.vo.YSGeneralVO;
import com.thebeastshop.sensors.vo.YSOrderChangeVO;
import com.thebeastshop.sensors.vo.YSOrderReturnVO;
import com.thebeastshop.sensors.vo.YSOrderSumVO;
import com.thebeastshop.sensors.vo.YSSkuInfoVO;
import java.util.Collection;
import java.util.Date;

public class BeastYoushuClient {
    private KafkaDriver kafkaDriver;
    private boolean enable;

    public <T> void generalEvent(YSGeneralVO<T> data) {
        this.send(TrackTypeEnum.YOUSHU_GENERAL, (T)data);
    }

    public void orderSum() {
        YSOrderSumVO orderSumVO = new YSOrderSumVO();
        orderSumVO.setRefDate(new Date());
        this.send(TrackTypeEnum.ORDER_SUM, orderSumVO);
    }

    public void orderReturn(YSOrderReturnVO orderReturnVO) {
        this.send(TrackTypeEnum.YS_ORDER_RETURN, orderReturnVO);
    }

    public void orderStatusChange(YSOrderChangeVO orderChangeVO) {
        this.send(TrackTypeEnum.ORDER_STATUS_CHANGE, orderChangeVO);
    }

    public void skuInfoAdd(YSSkuInfoVO skuInfoVO) {
        this.send(TrackTypeEnum.SKU_ADD, skuInfoVO);
    }

    public void skuInfoUpdate(YSSkuInfoVO skuInfoVO) {
        this.send(TrackTypeEnum.SKU_UPDATE, skuInfoVO);
    }

    public void addWxappVisitData() {
        this.send(TrackTypeEnum.ADD_WXAPP_VISIT_DATA, null);
    }

    public KafkaDriver getKafkaDriver() {
        return this.kafkaDriver;
    }

    public void setKafkaDriver(KafkaDriver kafkaDriver) {
        this.kafkaDriver = kafkaDriver;
    }

    private <T> void send(TrackTypeEnum trackType, T data) {
        this.send(new TrackDataVO(trackType, data));
    }

    private <T> void send(TrackDataVO<T> trackDataVO) {
        if (this.enable) {
            this.kafkaDriver.send(trackDataVO, "youshu");
        }
    }

    private <T extends Collection<R>, R extends CommonVO> void send(TrackTypeEnum trackType, T data) {
        if (this.enable) {
            this.kafkaDriver.send((Object)new TrackDataVO(trackType, data), "youshu");
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

