/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.exception;

/***
 * 渠道接口异常
 *
 * @author fs
 */
public class SalesOrderException extends RuntimeException {

    private static final long serialVersionUID = 6951011454223618244L;

    private final String errorCode;
    
    private String errorMessage;

    public SalesOrderException(final String errorCode) {
        super();
        this.errorCode = errorCode;
    }

    public SalesOrderException(final String errorCode, final Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public SalesOrderException(final String errorCode, final String msg) {
        super(msg);
        this.errorCode = errorCode;
    }
    
    public SalesOrderException(final String errorCode,final String errorMessage, final String msg) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public SalesOrderException(final String errorCode, final String msg, final Throwable cause) {
        super(msg, cause);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return errorCode;
    }
    public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
}