package com.thebeastshop.privilege.enumeration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2017/4/17
 * 实例类型实例类型 1.折扣 2.积分 3.线上券 4.线下券 5.第三方券 6.积分兑换 7.每月免邮 8:礼包免邮 9:海淘免邮 10.商品权益 11.每日求签
 */
public enum InstanceTypeEnum implements Serializable{
    DISCOUNT(1, "折扣"),
    POINT(2, "积分"),
    ONLINE_TICKET(3, "线上券"),
    OFFLINE_TICKET(4, "线下券"),
    THIRD_PARTY_TICKET(5, "第三方券"),
    POINT_EXCHANGE(6, "积分兑换"),
    MONTH_FREE(7, "每月免邮"),
    PACKAGE_FREE(8, "礼包免邮"),
    CROSS_FREE(9, "海淘免邮"),
    PRODUCT_INTERESTS(10, "商品权益"),
    KAU_CIM(11, "每日求签"),
    BIRTHDAY_GIFT(14, "生日到店礼"),
    INTERES_FREE(15, "免邮权益"),
    BIRTH_DISCOUNT(16, "生日折扣");

    private Integer id;
    private String name;
    public static final List<InstanceTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(InstanceTypeEnum.values()));

    InstanceTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static InstanceTypeEnum getEnumById(Integer id) {
        InstanceTypeEnum[] values = InstanceTypeEnum.values();
        for (InstanceTypeEnum item : values) {
            if (item.getId().equals(id)) {
                return item;
            }
        }
        return null;
    }
}
