package com.thebeastshop.privilege.exception;

/**
 * Created by xiaodong.cheng on 2018/1/29.
 */
public enum PrivilegeBusinessMsg {
    //系统错误
    E9999("9999","系统繁忙,请稍后再试"),
    E9001("9001","参数为空"),
    E9002("9002","参数缺失"),
    E9003("9003","非法参数"),
    E9101("9101","数据不唯一"),
    E9102("9102","并发导致查询数据与更新数据不一致"),
    E9103("9103","数据错误，该条数据不该不存在"),
    E9104("9104","数据错误，该条数据不合法"),
    E9105("9105","插入失败"),
    E9106("9106","删除失败"),
    E9107("9107","更新失败"),


    //商品权益异常
    E101("101","新增商品权益数据失败"),
    E102("102","保存商品权益失败"),
    E103("103","保存商品权益SKU失败"),
    E104("104","商品权益发放失败"),
    E105("105","更新数据失败"),
    E106("106","更新商品权益兑换数量失败"),
    E107("107","更新商品权益用户兑取状态失败"),
    E108("108","更新商品权益领取数量失败"),
    E109("109","商品权益互换SKU失败"),
    E110("110","删除数据失败"),
    E111("111","删除商品权益失败"),
    E112("112","删除商品权益SKU失败"),
    E113("113","查询数据异常"),
    E114("114","未找到权益商品"),
    E115("115","商品权益不在兑换时间范围"),
    E116("116","兑换商品权益超额"),
    E117("117","未设置商品权益有效兑取时间"),
    E118("118","商品权益不在领取时间范围"),
    E119("119","权益商品库存不足"),
    E120("120","返还商品权益数量超额"),
    E121("121","商品权益加入购物车失败"),
    E122("122","未找到该权益商品指定SKU Code的权益商品SKU记录"),
    E123("123","商品权益释放库存失败"),
    E124("124","该用户不存在该sku的未兑换商品权益记录"),
    E125("125","商品权益更改预库存失败"),

    E126("126","发放失败，已领完"),
    E127("127","发放失败，权益不在可领取时间内"),
    E128("128","发放失败，网络异常请稍后再试"),

    //免邮权益异常
    E201("201","该用户领取数已达到这次免邮权益单用户限领次数"),
    E202("202","免邮权益领取失败"),
    E203("203","未找到免邮权益"),
    E204("204","该免邮权益已被领取完"),
    E205("205","免邮次数不得小于已使用最大次数"),
    E206("206","限领数量不得小于已领取数量"),
    E207("207","单个用户限领数不得小于目前已领取数"),
    E208("208","更新失败，免邮权益不存在"),
    E209("209","插入失败，插入免邮适用商品出错"),
    E210("210","传入数据有问题，productVOS与Categories均为空"),
    E211("211","插入失败，插入免邮信息不成功"),
    E212("212","未找到该条免邮权益的领取记录"),
    E213("213","该免邮权益领取的会员不是此次消费的会员"),
    E214("214","该免邮权益的适用平台不包括此次消费的平台"),
    E215("215","不在该免邮权益使用时间范围内"),
    E216("216","该免邮权益已过期"),
    E217("217","该免邮权益使用次数超限"),
    E218("218","不存在该免邮权益发放记录"),
    E219("219","该免邮权益使用数为0"),
    E220("220","该免邮权益的线下消费门店不包括此次消费的门店"),
    E221("221","存在错误的商品code"),

    E301("301","找不到对应生日礼"),
    E302("302","该会员已经使用过该权益"),
    E303("303","该会员激活权益失败"),
    E304("304","该会员返还生日到店礼权益失败"),
    E305("305","该会员核销生日到店礼权益失败"),
    E306("306","该会员已经激活过生日到店礼权益"),
    E307("307","该会员没有本店生日到店礼权益"),

    E401("401","该商场没有活动"),
    E402("402","无此订单号"),
    E403("403","该订单没有退款组合金额"),
    E404("404","有无效商场活动"),
    E405("405","此订单已经退过款"),
    E406("406","此订单退款金额大于支付金额，无法退款"),
    E407("407","加入活动失败"),
    E408("408","没有此活动"),
    E409("409","活动未开始"),

    E501("501","活动不在有效期"),
    E502("502","活动已超过最大申领份数"),

    E601("601","超过单用户限购数"),
    E602("602","商品限量已抢完"),
    E603("603","限量活动未开始或者已结束"),
    E604("604","未找到限量订单"),
    E605("605","限量订单已取消，请勿多次取消"),
    ;

    private String code;
    private String msg;

    PrivilegeBusinessMsg(String code, String msg){
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
