/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.price.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCampaignVO;
import com.thebeastshop.price.vo.PrsGiftCardVO;
import com.thebeastshop.price.vo.PrsInterestGoodsVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PrsPriceStepVO
extends BaseDO {
    private static final long serialVersionUID = 1L;
    private PrsPriceTypeEnum priceType;
    private Long extId;
    private BigDecimal priceChange;
    private String stepDesc;
    private PrsCampaignVO campaign;
    private List<PrsAdditionalPackVO> additionalPackList;
    private PrsInterestGoodsVO interestGoodsVO;
    private List<PrsGiftCardVO> giftCardList;
    private Integer points;

    public PrsPriceStepVO() {
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.setScale(2, 4).negate();
        this.generateStepDesc();
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, String stepDesc) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.setScale(2, 4).negate();
        this.stepDesc = stepDesc;
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, Integer points) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.setScale(2, 4).negate();
        this.points = points;
        this.generateStepDesc();
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, PrsCampaignVO campaign) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.setScale(2, 4).negate();
        this.campaign = campaign;
        this.generateStepDesc();
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, PrsCampaignVO campaign, List<PrsAdditionalPackVO> additionalPackList) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.setScale(2, 4).negate();
        this.campaign = campaign;
        this.additionalPackList = additionalPackList;
        this.generateStepDesc();
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, PrsInterestGoodsVO interestGoodsVO) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.setScale(2, 4).negate();
        this.interestGoodsVO = interestGoodsVO;
        this.generateStepDesc();
    }

    private void generateStepDesc() {
        if (StringUtils.isBlank((CharSequence)this.stepDesc)) {
            this.stepDesc = this.campaign != null ? this.campaign.getTitle() : this.priceType.getName();
            if (this.points != null) {
                this.stepDesc = this.points + this.stepDesc;
            }
        }
    }

    public PrsCampaignVO getCampaign() {
        return this.campaign;
    }

    public void setCampaign(PrsCampaignVO campaign) {
        this.campaign = campaign;
    }

    public List<PrsAdditionalPackVO> getAdditionalPackList() {
        return this.additionalPackList;
    }

    public void setAdditionalPackList(List<PrsAdditionalPackVO> additionalPackList) {
        this.additionalPackList = additionalPackList;
    }

    public void addAdditionalPack(PrsAdditionalPackVO additionalPackVO) {
        if (CollectionUtils.isEmpty(this.additionalPackList)) {
            this.additionalPackList = new ArrayList<PrsAdditionalPackVO>();
        }
        this.additionalPackList.add(additionalPackVO);
    }

    public PrsInterestGoodsVO getInterestGoodsVO() {
        return this.interestGoodsVO;
    }

    public void setInterestGoodsVO(PrsInterestGoodsVO interestGoodsVO) {
        this.interestGoodsVO = interestGoodsVO;
    }

    public PrsPriceTypeEnum getPriceType() {
        return this.priceType;
    }

    public void setPriceType(PrsPriceTypeEnum priceType) {
        this.priceType = priceType;
    }

    public Long getExtId() {
        return this.extId;
    }

    public void setExtId(Long extId) {
        this.extId = extId;
    }

    public BigDecimal getPriceChange() {
        return this.priceChange;
    }

    public void setPriceChange(BigDecimal priceChange) {
        this.priceChange = priceChange;
    }

    public String getStepDesc() {
        return this.stepDesc;
    }

    public void setStepDesc(String stepDesc) {
        this.stepDesc = stepDesc;
    }

    public List<PrsGiftCardVO> getGiftCardList() {
        return this.giftCardList;
    }

    public void setGiftCardList(List<PrsGiftCardVO> giftCardList) {
        this.giftCardList = giftCardList;
    }

    public Integer getPoints() {
        return this.points;
    }

    public void setPoints(Integer points) {
        this.points = points;
    }
}

