/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.price.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.price.enums.PrsErrorCodeEnum;
import com.thebeastshop.price.exception.PrsException;
import java.util.ArrayList;

public enum PrsDiscountTypeEnum {
    PRICE_DISCOUNT(1, "\u4ef7\u683c\u6298\u6263", 1),
    FULL_CUT(2, "\u6ee1\u51cf", 2),
    FULL_GIFT(3, "\u6ee1\u8d60", 3),
    CHEAPEN_OTHER(4, "\u6362\u8d2d", 4),
    FULL_DISCOUNT(5, "\u6ee1\u6298", 2),
    PANIC_BUY(6, "\u62a2\u8d2d", 0),
    OPTION(7, "N\u5143\u4efb\u9009", 2),
    GROUP_BUY(8, "\u56e2\u8d2d", 5);

    private Integer id;
    private String name;
    private Integer sort;

    private PrsDiscountTypeEnum(Integer id, String name, Integer sort) {
        this.id = id;
        this.name = name;
        this.sort = sort;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static PrsDiscountTypeEnum getEnumById(Integer id) {
        for (PrsDiscountTypeEnum e : PrsDiscountTypeEnum.values()) {
            if (!e.getId().equals(id)) continue;
            return e;
        }
        throw new PrsException(PrsErrorCodeEnum.DISCOUNT_TYPE_ERROR);
    }

    public static boolean isNonPriceDiscountType(PrsDiscountTypeEnum discountType) {
        ArrayList nonPriceDiscountTypeList = Lists.newArrayList((Object[])new PrsDiscountTypeEnum[]{FULL_CUT, FULL_GIFT, CHEAPEN_OTHER, FULL_DISCOUNT, OPTION});
        return nonPriceDiscountTypeList.contains((Object)discountType);
    }

    public String toString() {
        return this.getId().toString();
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }
}

