/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.payment.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.CodeEnum;

public enum PPaymentChannelEnum implements CodeEnum<Integer>
{
    CASH(1, "\u73b0\u91d1"),
    DEBIT_CARD(2, "\u501f\u8bb0\u5361"),
    CREDIT_CARD(3, "\u4fe1\u7528\u5361"),
    WEIXIN_MOBILE(4, "\u5fae\u4fe1\u79fb\u52a8\u652f\u4ed8"),
    WEIXIN_MINI_PROGRAM(5, "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8"),
    ALIPAY_MOBILE(6, "\u652f\u4ed8\u5b9d\u79fb\u52a8\u652f\u4ed8"),
    ALI_CROSS_BORDER_MOBILE(7, "\u652f\u4ed8\u5b9d\u8de8\u5883\u79fb\u52a8\u652f\u4ed8"),
    ALIPAY_DIRECT(8, "\u652f\u4ed8\u5b9d\u5373\u65f6\u652f\u4ed8"),
    TRANSFER(9, "\u8f6c\u8d26"),
    YCK(10, "\u9884\u5b58\u6b3e"),
    YEZHU(11, "\u4e1a\u4e3b"),
    ALI_BANK(12, "\u652f\u4ed8\u5b9d\u7f51\u94f6"),
    SCAN(13, "\u626b\u63cf\u652f\u4ed8"),
    WEIXIN_SCAN(14, "\u5fae\u4fe1B\u626bC"),
    ALIPAY_SCAN(15, "\u652f\u4ed8\u5b9dB\u626bC"),
    WEIXIN_OFFICIAL_ACCOUNT(16, "\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8"),
    GIFT_CARD(17, "\u793c\u54c1\u5361"),
    ALI_CROSS_BORDER_DIRECT(18, "\u652f\u4ed8\u5b9d\u8de8\u5883\u5373\u65f6\u652f\u4ed8"),
    ALIPAY_WAP_DIRECT(19, "\u652f\u4ed8\u5b9dWAP\u5373\u65f6\u652f\u4ed8"),
    ALI_WAP_CROSS_BORDER_DIRECT(20, "\u652f\u4ed8\u5b9dWAP\u8de8\u5883\u5373\u65f6\u652f\u4ed8"),
    INTEGRAL(21, "\u79ef\u5206"),
    WEIXIN_USER_SCAN(22, "\u7528\u6237\u5fae\u4fe1\u626b\u7801\u652f\u4ed8"),
    ALIPAY_USER_SCAN(23, "\u7528\u6237\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8"),
    CMB(24, "\u62db\u5546\u94f6\u884c\u652f\u4ed8"),
    MARKET_COUPON(25, "\u5546\u573a\u5238"),
    WEIXIN_DIRECT(26, "\u5fae\u4fe1\u5373\u65f6\u652f\u4ed8"),
    QUICK_PASS_SCAN(27, "\u94f6\u8054\u4e91\u95ea\u4ed8"),
    FUND(28, "\u57fa\u91d1"),
    ELEME(29, "\u997f\u4e86\u4e48"),
    TM_SHOPPING_FUND(30, "\u5929\u732b\u8d2d\u7269\u91d1"),
    TM_INTERESTS_FUND(31, "\u5929\u732b\u6743\u76ca\u91d1"),
    SHOPPING_MALL_APP(32, "\u5546\u573a\u5c0f\u7a0b\u5e8f"),
    MERCHANTS_PAY_MARKETING_DISCOUNT(33, "\u5546\u5bb6\u652f\u4ed8\u8425\u9500\u4f18\u60e0"),
    GROUP_BUYING_VOUCHER(34, "\u56e2\u8d2d\u5238"),
    WORK_WEIXIN_TRANSFER(35, "\u4f01\u4e1a\u5fae\u4fe1\u8f6c\u8d26"),
    PAYPAL(36, "PayPal"),
    MANUAL(37, "Manual"),
    VISA(38, "Visa"),
    MASTERCARD(39, "MasterCard"),
    AMERICAN_EXPRESS(40, "American Express");

    private Integer id;
    private String name;

    private PPaymentChannelEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getCode() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static PPaymentChannelEnum getEnumByCode(Integer code) {
        for (PPaymentChannelEnum e : PPaymentChannelEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static boolean isOversea(PPaymentChannelEnum paymentChannel) {
        return Lists.newArrayList((Object[])new PPaymentChannelEnum[]{ALI_CROSS_BORDER_MOBILE, ALI_CROSS_BORDER_DIRECT, ALI_WAP_CROSS_BORDER_DIRECT}).contains((Object)paymentChannel);
    }
}

