package com.thebeastshop.payment.enums;

import com.thebeastshop.common.enums.CodeEnum;

/**
 * 支付渠道枚举
 *
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 支付渠道
 */
public enum PPaymentChannelEnum implements CodeEnum<Integer> {
    CASH(1, "现金"),
    DEBIT_CARD(2, "借记卡"),
    CREDIT_CARD(3, "信用卡"),
    WEIXIN_MOBILE(4, "微信移动支付"),
    WEIXIN_MINI_PROGRAM(5, "微信小程序支付"),
    ALIPAY_MOBILE(6, "支付宝移动支付"),
    ALI_CROSS_BORDER_MOBILE(7, "支付宝跨境移动支付"),
    ALIPAY_DIRECT(8, "支付宝即时支付"),
    TRANSFER(9, "转账"),
    YCK(10, "预存款"),
    YEZHU(11, "业主"),
    ALI_BANK(12, "支付宝网银"),
	SCAN(13, "扫描支付"),
	WEIXIN_SCAN(14, "微信B扫C"),
	ALIPAY_SCAN(15, "支付宝B扫C"),
	WEIXIN_OFFICIAL_ACCOUNT(16, "微信公众号支付"),
	GIFT_CARD(17, "礼品卡"),
	ALI_CROSS_BORDER_DIRECT(18, "支付宝跨境即时支付"),
	ALIPAY_WAP_DIRECT(19, "支付宝WAP即时支付"),
	ALI_WAP_CROSS_BORDER_DIRECT(20, "支付宝WAP跨境即时支付"),
	INTEGRAL(21, "积分"),
	WEIXIN_USER_SCAN(22, "用户微信扫码支付"),
	ALIPAY_USER_SCAN(23, "用户支付宝扫码支付"),
    CMB(24, "招商银行支付"),
    MARKET_COUPON(25, "商场券"),
	;

	private Integer id;

	private String name;

	private PPaymentChannelEnum a;

	PPaymentChannelEnum(Integer id, String name) {
		this.id = id;
		this.name = name;
	}

    public Integer getCode() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static PPaymentChannelEnum getEnumByCode(Integer code) {
        for (PPaymentChannelEnum e : PPaymentChannelEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}


